'#Reference {420B2830-E718-11CF-893D-00A0C9054228}#1.0#0#C:\WINDOWS\system32\scrrun.dll#Microsoft Scripting Runtime

'Replacement for the Load Pull Wizard

Option Explicit

Type pt
    r As Double
    i As Double
End Type

Dim AC As Double
Dim AddGraphs As Boolean
Dim AngMax As Double
Dim AngParam As Parameter
Dim CG As Graph
Dim ConstPout As Double
Dim ConstPoutD As Double
Dim CurSwp As Integer
Dim DebugMode As Boolean
Dim DefAC As Double
Dim DefMC As Double
Dim DefMD As Double
Dim DefNMC As Double
Dim DefPPC As Double
Dim DefRad As Double
Dim E As Element
Dim EditPoints As Boolean
Dim EqnDict As New Dictionary
Dim ExistingFile As String
Dim FailedPntDict As New Dictionary
Dim FreqPntDict As New Dictionary
Dim G As Graph
Dim GName As String
Dim HarmonicVal As Integer
Dim HasConstPout As Boolean
Dim HasXDB As Boolean
Dim Imags() As Double
Dim LoadPullDFDict As New Dictionary
Dim LoadPullDFName As String
Dim LoadPullGName As String
Dim LPDF As DataFile
Dim LPFailDF As DataFile
Dim LPMeasDict As New Dictionary
Dim MagMax As Double
Dim MagParam As Parameter
Dim MarkerRad As Double
Dim MaxDict As New Dictionary
Dim MeasDict As New Dictionary
Dim MeasNameDict As New Dictionary
Dim MinDict As New Dictionary
Dim MC As Double
Dim MD As Double
Dim MultiPoint As Boolean
Dim NMC As Double
Dim OrigAng As String
Dim OrigMag As String
Dim PendingDict As New Dictionary
Dim PerformMultiple As Boolean
Dim PI As Double
Dim PlotContours As Boolean
Dim PlotContoursMax As Boolean
Dim PlotContoursMin As Boolean
Dim PlotConvergedPnts As Boolean
Dim PlotFailedPnts As Boolean
Dim PointDict As New Dictionary
Dim PropDFName As String
Dim PPC As Double
Dim PropDict As New Dictionary
Dim Rad As Double
Dim ReadExisting As Boolean
Dim Reals() As Double
Dim RegionalDelimiter As String
Dim S As Schematic
Dim SepIsPeriod As Boolean
Dim SFName As String
Dim ShouldSim As Boolean
Dim SimStatus As StatusGroup
Dim SourceDict As New Dictionary
Dim SplitChar As String
Dim StatusDict As New Dictionary
Dim StrDelim As String
Dim SupportMode As Boolean
Dim SupportName As String
Dim SweepTestMode As Boolean
Dim SwpCount As Integer
Dim SwpCtrlDict As New Dictionary
Dim SwpPntDict As New Dictionary
Dim SwpValDict As New Dictionary
Dim TestMode As Boolean
Dim TunerDict As New Dictionary
Dim TunerMeas() As String
Dim Tuners() As String
Dim UseBaseUnits As Boolean
Dim UseIterative As Boolean
Dim UseRadians As Boolean

Dim DATA_MAX As Double
Dim FAILED_POINTS As String
Dim HELP As String
Dim LP_MODE_FIXED_ANGLE
Dim LP_MODE_FIXED_NPTS
Dim LP_MODE_SQUARE
Dim LP_MODE_WIZARD
Dim SPECIAL_MEAS As String
Dim USER_MEAS_NAMES As String


' $MENU=Hidden
Sub Main

	Load_Pull_V11

End Sub

' $MENU=Load Pull
' $NAME=Obsolete - Load Pull v11
Sub Load_Pull_V11

	On Error GoTo uh_oh

	scriptSetup()

	checkForTuners()

	runGUI()

	manageSweeps()

	addCountoursToGraph()

	scriptEnd()

	uh_oh:

	giveErrMsg("An error has occured (" + CStr(Err.Number) + "-" + Err.Description + ") - Please contact AWR technical support")
	scriptEnd()

End Sub
Function scriptSetup() As Boolean

	Debug.Clear

	Dim testNum As Double

	If (MWOffice.ProjectOpen = False) Then
		End
	End If

	'For running regression tests
	TestMode = MWOffice.TestMode
	'TestMode = True

	'Test sweep manager without actually running load pull
	SweepTestMode = False

	'Verbose output
	DebugMode = False

	'Creates all load pull schematics but doesn't actually run them.  Used for tracking down sim failures.
	SupportMode = False

	UseBaseUnits = Project.Options("DependentParametersInBaseUnits").Value
	UseRadians = False
	If Project.Units(mwUT_Angle).UnitString = "Rad" Then
		UseRadians = True
	End If

	If (TestMode) Or (DebugMode) Or (SweepTestMode) Or (SupportMode) Then
		Debug.Print "Test Mode = " + CStr(TestMode)
		Debug.Print "Sweep Test Mode = " + CStr(SweepTestMode)
		Debug.Print "Debug Mode = " + CStr(DebugMode)
		Debug.Print "Support Mode = " + CStr(SupportMode)
		Debug.Print
	End If

	'Project.LockUpdates = True

	PI = Atn(1)*4
	DefRad = 0.95
	DefMC = 0
	DefAC = 0
	DefNMC = 5
	DefPPC = 10
	DefMD = LP_MODE_FIXED_ANGLE
	Rad = DefRad
	MC = DefMC
	AC = DefAC
	NMC = DefNMC
	PPC = DefPPC
	MD = DefMD

	MagMax = 0.9999
	AngMax = 180

	MarkerRad = 25
	ReadExisting = False
	EditPoints = False

	OrigMag = ""
	OrigAng = ""

	GName = "AWR_Load_Pull_Points"

	LoadPullDFName = "LP_Data"
	LoadPullGName = "LP_Data"

	PropDFName = "_Load_Pull_Wizard"

	SFName = "_Load_Pull_Wizard_Temp"

	SupportName = "__LP_WIZARD__"

	MultiPoint = False

	ConstPout = -800
	ConstPoutD = 0
	HasConstPout = False
	HasXDB = False

	PlotContours = True
	PlotContoursMax = False
	PlotContoursMin = False
	PlotConvergedPnts = False
	PlotFailedPnts = False

	StrDelim = "!!!"
	SplitChar = "^"

	AddGraphs = True

	PerformMultiple = False

	ShouldSim = False

	DATA_MAX = 1e308
	FAILED_POINTS = "_failed_points"
	HELP = "help"
	SPECIAL_MEAS = "*"
	USER_MEAS_NAMES = "userMeasNames"

	LP_MODE_FIXED_ANGLE = 0
	LP_MODE_FIXED_NPTS = 1
	LP_MODE_SQUARE = 3
	LP_MODE_WIZARD = 2

	Set StatusDict = New Dictionary
	Set SimStatus = MWOffice.Status.Groups.Add("Load Pull Wizard",MWOffice.Project)
	SimStatus.RemoveAllItems()

	getGraph()
	parseOutputEquations()

	testNum = 0.5
	RegionalDelimiter = "."
	SepIsPeriod = True
	If (InStr(CStr(testNum),",")) Then
		SepIsPeriod = False
		RegionalDelimiter = ","
	End If

End Function
Function scriptEnd() As Boolean

	Dim i As Integer

	If (Project.SimulationFilters.Exists(SFName)) Then
		Project.SimulationFilters.Remove(SFName)
	End If

	If (SupportMode = False) Then
		removeStuffFromSchem(True)
	End If

	If (ShouldSim) Then
		resimLPContours()
	End If

	If (Project.Graphs.Exists(G.Name)) Then
		Project.Graphs.Remove(G.Name)
	End If

	Project.LockUpdates = False

	For i=0 To StatusDict.Count-1
		If (StatusDict.Items(i) = MWOffice.mwRIC_Error) Then
			SimStatus.Items.Add(mwRIC_Error,StatusDict.Keys(i))
		ElseIf (StatusDict.Items(i) = MWOffice.mwRIC_Warning) Then
			SimStatus.Items.Add(mwRIC_Warning,StatusDict.Keys(i))
		ElseIf (StatusDict.Items(i) = MWOffice.mwRIC_Info) Then
			SimStatus.Items.Add(mwRIC_Info,StatusDict.Keys(i))
		End If
	Next i

	End

End Function
Function checkForTuners() As Boolean

	Dim ts As Schematic
	Dim tss As Schematics
	Dim te As Element
	Dim tes As Elements
	Dim tg As Graph
	Dim tgs As Graphs
	Dim tm As Measurement
	Dim tms As Measurements
	Dim mSource As String
	Dim eName As String
	Dim swpPort As Boolean
	Dim swpErr As Boolean
	Dim msg As String
	Dim swpMsg As String
	Dim i As Integer
	Dim removeDict As Dictionary

	Set removeDict = New Dictionary

	swpPort = False
	swpMsg = ""
	Set tss = Project.Schematics
	For Each ts In tss
		If (ts.LockLevel = mwDLL_Unlocked) Then
			Set tes = ts.Elements
			For Each te In tes
				If (te.Enabled) Then
					eName = Split(te.Name,".")(0)
					If ((eName = "LTUNER") Or (eName = "LTUNER2") Or (eName = "HBTUNER") Or (eName = "HBTUNER2")) Then
						If (TunerDict.Exists(ts.Name)) Then
							TunerDict(ts.Name) = TunerDict(ts.Name) + StrDelim + te.Name
						Else
							TunerDict(ts.Name) = te.Name
						End If
					ElseIf (eName = "PORT_PS1") Then
						removeDict(ts.Name) = ts.Name
					End If
				End If
			Next te
		End If
	Next ts

	If (removeDict.Count > 0) Then
		For i=0 To removeDict.Count-1
			If (TunerDict.Exists(removeDict.Keys(i))) Then
				TunerDict.Remove(removeDict.Keys(i))
				swpMsg = swpMsg + vbTab + removeDict.Keys(i) + vbLf
				swpPort = True
				msg = "The " + removeDict.Keys(i) + " schematic was skipped from Load Pull because Swept Power Ports are not supported"
				StatusDict(msg) = MWOffice.mwRIC_Warning
			End If
		Next i
	End If

	If (swpPort = True) Then
		msg = "The schematics listed below were excluded because they contain a swept power port." + vbLf + "Please use a SWPVAR instead.
		msg = msg + vbLf + vbLf
		msg = msg + "Schematics - " + vbLf
		msg = msg + swpMsg
		giveWarnMsg(msg)
	End If

	If (TunerDict.Count = 0) Then
		msg = "There are no schematics that contain a tuner element.  Please add one and run Load Pull again.  "
		msg = msg + "Only LTUNER, LTUNER2, HBTUNER, and HBTUNER2 tuners are currently supported."
		giveErrMsg(msg)
		scriptEnd()
	End If

	swpMsg = ""
	Set tgs = Project.Graphs
	For Each tg In tgs
		Set tms = tg.Measurements
		For Each tm In tms
			If (tm.Enabled) Then
				mSource = getMeasSource(tm.Name)
				If (isMeasClean(tm.Name)) Then
					If (TunerDict.Exists(mSource)) Then
						If (MeasDict.Exists(mSource)) Then
							MeasDict(mSource) = MeasDict(mSource) + StrDelim + tm.Name
						Else
							MeasDict(mSource) = tm.Name
						End If
					End If
					If (getMeasName(tm.Name) = "Eqn") Then
						getOutputEquationSources(getMeasSource(tm.Name),getMeasArgs(tm.Name))
						For i=0 To SourceDict.Count-1
							mSource = SourceDict.Keys(i)
							If (TunerDict.Exists(mSource)) Then
								If (MeasDict.Exists(mSource)) Then
									MeasDict(mSource) = MeasDict(mSource) + StrDelim + tm.Name
								Else
									MeasDict(mSource) = tm.Name
								End If
							End If
						Next i
					End If
				Else
					If (TunerDict.Exists(mSource)) Then
						swpMsg = swpMsg + vbTab + tm.Name + vbLf
						swpErr = True
						msg = "The " + mSource + " measurements were skipped from Load Pull because only measurements that plot all sweep points are allowed"
						StatusDict(msg) = MWOffice.mwRIC_Warning
					End If
				End If
			End If
			SourceDict.RemoveAll()
		Next tm
	Next tg

	'No need to keep sources that don't have measurements
	removeDict.RemoveAll()
	For i=0 To TunerDict.Count-1
		If (MeasDict.Exists(TunerDict.Keys(i)) = False) Then
			removeDict(TunerDict.Keys(i)) = TunerDict.Keys(i)
		End If
	Next i

	For i=0 To removeDict.Count-1
		If (TunerDict.Exists(removeDict.Keys(i))) Then
			TunerDict.Remove(removeDict.Keys(i))
		End If
	Next i

	If (swpErr = True) Then
		msg = "The measurements listed below were excluded because they parse swept variables." + vbLf + "Only measurements that plot all sweep points are allowed"
		msg = msg + vbLf + vbLf
		msg = msg + "Measurements - " + vbLf
		msg = msg + swpMsg
		giveWarnMsg(msg)
	End If

	If (MeasDict.Count = 0) Then
		msg = "There are no valid measurements for the schematics that contain a tuner element - please add one and run Load Pull again"
		giveErrMsg(msg)
		scriptEnd()
	End If

End Function
Function isMeasClean (mName As String) As Boolean

	Dim tok As String
	Dim toks() As String
	Dim i As Integer
	Dim ret As Boolean

	ret = True

	If (InStr(mName,"[")) Then
		tok = Split(mName,"[")(1)
		tok = Split(tok,"]")(0)
		toks = Split(tok,",")
		For i=0 To UBound(toks)
			tok = toks(i)
			If (tok <> "*") Then
				ret = False
			End If
		Next i
	End If

	isMeasClean = ret

End Function
Function runGUI() As Boolean

	Dim dfDefault As String
	Dim df As DataFile
	Dim dfDict As New Dictionary
	Dim dfName As String
	Dim dfNames() As String
	Dim dfs As DataFiles
	Dim func As Integer
	Dim hasErr As Boolean
	Dim i As Integer

	dfDefault = "Default"

	Set dfs = Project.DataFiles
	For Each df In dfs
		If (InStr(df.Name,PropDFName)) Then
			If (df.Name = PropDFName) Then
				Set dfDict(dfDefault) = df
			Else
				Set dfDict(df.Name) = df
			End If
		End If
	Next

	If (dfDict.Count > 1) Then
		ReDim dfNames(dfDict.Count - 1)
		For i = 0 To dfDict.Count - 1
			dfNames(i) = dfDict.Keys(i)
		Next
	Begin Dialog UserDialog 400,126,"Choose Load Pull Configuration" ' %GRID:10,7,1,1
		OKButton 200,98,90,21
		CancelButton 300,98,90,21
		ListBox 10,7,380,84,dfNames(),.dfName
	End Dialog
		Dim dlg As UserDialog
		func = Dialog(dlg)
		If (func = 0) Then
			scriptEnd()
		End If
		dfName = dfNames(dlg.dfName)
		If (dfName = dfDefault) Then
			dfName = PropDFName
		End If
		If (Project.DataFiles.Exists(dfName)) And (dfName <> PropDFName) Then
			Set df = Project.DataFiles(dfName)
			If (Project.DataFiles.Exists(PropDFName)) Then
				Project.DataFiles.Remove(PropDFName)
			End If
			Project.DataFiles.Copy(dfName,PropDFName)
		End If
	End If

	runSetupGUI()

	hasErr = True
	While (hasErr)
		runLoadPullGUI(hasErr,func)
		If (func = 0) Then	'User pressed Cancel
			scriptEnd()
		End If
		If (func = 1) Then
			hasErr = True
			runSetupGUI()
		End If
	Wend

End Function
Function runSetupGUI() As Boolean

	Dim hasErr As Boolean

	runPointSelectGUI()

	If (EditPoints) Then
		G.Measurements.RemoveAll()
		drawPointsOnGraph(True,True)
		hasErr = True
		While (hasErr)
			getPointsFromGraph(hasErr)
		Wend
	End If

	If (PointDict.Count = 0) Then
		giveErrMsg("An error has occured, no impedance points were calculated.  If using a data file to define impedance points please ensure that the file is properly formatted.  Contact AWR Support for additional assistance.")
		scriptEnd()
	End If

	'closeGraphWindows()

	'reorderPoints()

End Function
Function checkDlgVals(runSilent As Boolean) As Boolean

	Dim hasErr As Boolean

	hasErr = False

	If (Rad < 0) Then
		If (runSilent = False) Then
			giveErrMsg("Radius must be > 0")
		End If
		Rad = DefRad
		hasErr = True
	ElseIf (Rad > MagMax) Then
		If (runSilent = False) Then
			giveErrMsg("Radius must be <= " + CStr(MagMax))
		End If
		Rad = MagMax
		hasErr = True
	End If

	If (MC < 0) Then
		If (runSilent = False) Then
			giveErrMsg("Center magnitude must be > 0")
		End If
		MC = DefMC
		hasErr = True
	ElseIf (MC > 0.95) Then
		If (runSilent = False) Then
			giveErrMsg("Magnitude center must be <= " + CStr(Val("0.95")))
		End If
		MC = DefMC
		hasErr = True
	End If

	If (AC < -AngMax) Then
		If (runSilent = False) Then
			giveErrMsg("Center angle must be >= -" + CStr(AngMax))
		End If
		AC = -AngMax
		hasErr = True
	ElseIf (AC > AngMax) Then
		If (runSilent = False) Then
			giveErrMsg("Center angle must be <= " + CStr(AngMax))
		End If
		AC = AngMax
		hasErr = True
	End If

	If (NMC < 0) Then
		If (runSilent = False) Then
			giveErrMsg("Number of circles must be > 0")
		End If
		NMC = DefNMC
		hasErr = True
	ElseIf (NMC > 40) Then
		If (runSilent = False) Then
			If (MD < 3) Then
				giveErrMsg("Number of rows / cols must be <= 40")
			Else
				giveErrMsg("Number of circles must be <= 40")
			End If
		End If
		NMC = DefNMC
		hasErr = True
	End If

	If (PPC <= -0) Then
		If (runSilent = False) Then
			giveErrMsg("Number of circles points must be > 0")
		End If
		PPC = DefPPC
		hasErr = True
	ElseIf (PPC > 100) Then
		If (runSilent = False) Then
			giveErrMsg("Number of circles points must be <= 100")
		End If
		PPC = DefPPC
		hasErr = True
	End If

	If (MD > 3) Then
		If (runSilent = False) Then
			giveErrMsg("Mode must be less than 2")
		End If
		MD = DefMD
		hasErr = True
	End If

	If (MD = LP_MODE_SQUARE) And (NMC = 1) Then
		'Prevent divide by 0.  Safe to do here since NMC = 1 doesn't make sense for a square.
		If (NMC = 1) Then
			NMC = 2
		End If
	End If

	checkDlgVals = hasErr

End Function
Function runPointSelectGUI() As Boolean

	Dim mode() As String
	Dim fNames() As String
	Dim func As Integer
	Dim lpd As DataFile
	Dim lpds As DataFiles
	Dim foundFile As Boolean
	Dim i As Integer

	ReDim mode(3)

	mode(0) = "Fixed Angle Between Circular Points"
	mode(1) = "Fixed Number of Circular Points"
	mode(2) = "Load Pull Wizard Mode"
	mode(3) = "Fixed Number of Square Points"

	i = 0
	foundFile = False
	Set lpds = Project.DataFiles
	For Each lpd In lpds
		If ((InStr(lpd.Filename,".lp") <>  0) Or (InStr(lpd.Filename,".sp") <> 0) Or (InStr(lpd.Filename,".txt") <> 0)) Then
			ReDim Preserve fNames(i)
			fNames(i) = lpd.Name
			i = i+1
			foundFile = True
		End If
	Next lpd

	If (foundFile) Then
		alphaSort(fNames)
	End If

	Begin Dialog UserDialog 930,266,"Load Pull Points",.dlgPointSelectFunc ' %GRID:10,7,1,1
		GroupBox 10,7,450,224,"User Defined Points",.GroupBox1
		GroupBox 470,7,450,168,"File Defined Points",.GroupBox2
		GroupBox 470,175,450,56,"Options",.GroupBox3
		GroupBox 290,28,140,112,"Point Density",.GroupBox4
		Text 30,154,160,14,"Mode",.Text6
		Text 30,42,90,14,"Radius",.Text1
		Text 30,63,160,14,"Center Magnitude",.Text2
		Text 30,84,160,14,"Center Angle",.Text3
		Text 30,105,160,14,"Number of Circles",.Text4
		Text 30,126,160,14,"Points Per Circle",.Text5
		TextBox 190,35,90,21,.circleRadius
		TextBox 190,56,90,21,.centerMag
		TextBox 190,77,90,21,.centerAng
		TextBox 190,98,90,21,.numCircles
		TextBox 190,119,90,21,.pointsPerCircle
		PushButton 600,238,100,21,"Next",.PushButton1
		CancelButton 710,238,100,21
		ListBox 160,154,280,56,mode(),.lpMode
		ListBox 510,56,390,105,fNames(),.existingFile
		CheckBox 500,196,220,14,"Edit Points On Graph",.editPoints
		CheckBox 510,35,220,14,"Read Existing Load Pull File",.readFile
		OptionGroup .lpWiz
			OptionButton 310,49,90,14,"Coarse",.OptionButton1
			OptionButton 310,70,90,14,"Medium",.OptionButton2
			OptionButton 310,91,90,14,"Fine",.OptionButton3
			OptionButton 310,112,90,14,"Extra Fine",.OptionButton4
		PushButton 820,238,90,21,"Help",.help
	End Dialog
	Dim dlg As UserDialog

	func = Dialog(dlg)

	If (func = 0) Then
		scriptEnd()
	End If

	EditPoints = dlg.editPoints

	Rad = CDbl(getRegionalString(dlg.circleRadius))
	MC = CDbl(getRegionalString(dlg.centerMag))
	AC = CDbl(getRegionalString(dlg.centerAng))
	NMC = CDbl(getRegionalString(dlg.numCircles))
	PPC = CDbl(getRegionalString(dlg.pointsPerCircle))
	MD = dlg.lpMode

End Function
Function runLoadPullGUI(ByRef hasErr As Boolean, ByRef func As Integer) As Boolean

	Dim ele As Element
	Dim eles As Elements
	Dim foundMatch As Boolean
	Dim i As Integer
	Dim lpg As Graph
	Dim lpgs As Graphs
	Dim lpm As Measurement
	Dim lpms As Measurements
	Dim meass As String
	Dim measHeaderDict As New Dictionary
	Dim mName As String
	Dim mCleanName As String
	Dim nameErr As Boolean
	Dim schems() As String
	Dim specialName As String
	Dim toks() As String
	Dim userName As String
	Dim userNames As String
	Dim userNameDict As New Dictionary

	hasErr = False

	ReDim schems(TunerDict.Count-1)

	For i=0 To TunerDict.Count-1
		schems(i) = TunerDict.Keys(i)
	Next i

	alphaSort(schems)

	Begin Dialog UserDialog 980,357,"Setup Load Pull",.dlgLoadPullFunc ' %GRID:10,7,1,1
		GroupBox 10,7,470,105,"Schematics",.GroupBox1
		GroupBox 490,7,470,105,"Output Options",.GroupBox4
		GroupBox 490,119,470,112,"Auto Graph Options",.GroupBox5
		GroupBox 490,238,470,84,"Load Pull Options",.GroupBox6
		GroupBox 10,119,470,112,"Measurements",.GroupBox2
		GroupBox 10,238,470,84,"Tuners",.GroupBox3
		ListBox 30,28,430,77,schems(),.schem
		ListBox 30,259,430,28,Tuners(),.Tuner
		MultiListBox 30,140,430,70,TunerMeas(),.meas
		OKButton 570,329,90,21
		CancelButton 670,329,90,21
		'.CheckBox 520,280,340,14,"Use Tuner (No Cancel Button)",.fastMode
		Text 510,35,160,14,"Load Pull Data File Name",.Text3
		Text 510,63,210,14,"Load Pull Contour Graph Name",.Text5
		TextBox 720,28,220,21,.fName
		TextBox 720,56,220,21,.gName
		OptionGroup .harmonic
			OptionButton 40,294,130,14,"1st Harmonic",.OptionButton1
			OptionButton 180,294,130,14,"2nd Harmonic",.OptionButton2
			OptionButton 320,294,130,14,"3rd Harmonic",.OptionButton3
		PushButton 770,329,90,21,"Back",.back
		CheckBox 510,84,240,14,"Automatically overwrite if files exist",.overwriteFiles
		CheckBox 520,259,360,14,"Perform multiple simulations without prompting",.performMultiple
		CheckBox 520,140,130,14,"Plot Contours",.plotContours
		CheckBox 520,161,170,14,"Plot Contour Max",.plotContoursMax
		CheckBox 520,182,170,14,"Plot Contour Min",.plotContoursMin
		CheckBox 730,140,210,14,"Plot Converged Impedances",.plotConverged
		CheckBox 730,161,210,14,"Plot Failed Impedances",.plotFailed
		PushButton 30,210,90,14,"Select All",.selectAll
		PushButton 780,84,160,14,"Use Schematic Name",.useSchName
		CheckBox 520,280,310,14,"Set custom load pull file column names",.customHeader
		CheckBox 520,301,360,14,"Fast solver (stops on convergence failure)",.useIterative
		PushButton 870,329,90,21,"Help",.help
	End Dialog
	Dim dlg As UserDialog
	func = Dialog(dlg)

	If (func >= 0) Then
		Exit Function
	End If

	PlotContours = dlg.plotContours
	PlotContoursMax = dlg.plotContoursMax
	PlotContoursMin = dlg.plotContoursMin
	PlotConvergedPnts = dlg.plotConverged
	PlotFailedPnts = dlg.plotFailed

	If (PlotContours) Or (PlotContoursMax) Or (PlotContoursMin) Or (PlotConvergedPnts) Or (PlotFailedPnts) Then
		AddGraphs = True
	Else
		AddGraphs = False
	End If

	If (dlg.schem = -1) Then
		giveErrMsg("One schematic must be selected")
		hasErr = True
		Exit Function
	End If

	If dlg.fName = "" Then
		LoadPullDFName = "LP_Data"
		giveErrMsg("A DataFile name must be entered")
		hasErr = True
		Exit Function
	End If

	If (dlg.gName = "") And (AddGraphs = True) Then
		LoadPullGName = "LP_Data"
		giveErrMsg("A Graph name must be entered")
		hasErr = True
		Exit Function
	End If

	If (UBound(dlg.meas) = -1) Then
		giveErrMsg("At least one measurement must be selected")
		hasErr = True
		Exit Function
	End If

	If (dlg.Tuner = -1) Then
		giveErrMsg("At least one tuner must be selected")
		hasErr = True
		Exit Function
	End If

	PerformMultiple = False
	If (dlg.performMultiple) Then
		PerformMultiple = True
	End If

	If (dlg.overwriteFiles = 0) Then
		If (Project.DataFiles.Exists(dlg.fName)) Then
			nameErr = True
			While(nameErr)
				nameErr = False
				func = giveYesNoMsg("A Datafile named """ + dlg.fName + """ already exists, are you sure you want to overwrite it?")
				If (func = 7) Then
					Begin Dialog UserDialog 400,105,"File Rename" ' %GRID:10,7,1,1
						Text 20,14,350,14,"Enter a new load pull data file name",.Text1
						TextBox 20,35,340,21,.fName
						OKButton 150,70,90,21
					End Dialog
					Dim dlg2 As UserDialog
						dlg2.fName = dlg.fName
					Dialog dlg2

					If (Project.DataFiles.Exists(dlg2.fName)) Then
						nameErr = True
					End If
					dlg.fName = dlg2.fName
				End If
			Wend
		End If

		If (Project.Graphs.Exists(dlg.gName)) Then
			nameErr = True
			While(nameErr)
				nameErr = False
				func = giveYesNoMsg("A Graph named """ + dlg.fName + """ already exists, are you sure you want to overwrite it?")
				If (func = 7) Then
					Begin Dialog UserDialog 400,105,"File Rename" ' %GRID:10,7,1,1
						Text 20,14,350,14,"Enter a new load pull graph file name",.Text1
						TextBox 20,35,340,21,.gName
						OKButton 150,70,90,21
					End Dialog
					Dim dlg3 As UserDialog
						dlg3.gName = dlg.gName
					Dialog dlg3

					If (Project.Graphs.Exists(dlg3.gName)) Then
						nameErr = True
					End If
					dlg.gName = dlg3.gName
				End If
			Wend
		End If
	End If

	Set S = Project.Schematics(schems(dlg.schem))
	Set E = S.Elements(Tuners(dlg.Tuner))
	If (InStr(LCase(S.Name),HELP)) Then
		SupportMode = True
	End If

	getSweeps()

	Set eles = S.Elements
	For Each ele In eles
		If (InStr(ele.Name,"SWPVAR")) Then
			SwpCtrlDict(ele.Name) = ele.Enabled
			ele.Enabled = False
		ElseIf (InStr(ele.Name,"XDB")) Then
			HasXDB = True
		ElseIf ((InStr(ele.Name,"CONSTPOUT") And (ele.Enabled))) Then
			ConstPout = ele.Parameters("POUT").ValueAsDouble + 30
			'ConstPOUTD = ele.Parameters("ERR").ValueAsDouble
			HasConstPout = True

			Debug.Print "ConstPOUT = " + CStr(ConstPout)
			Begin Dialog UserDialog 470,294,"Constant Output Power Info",.dlgConstPoutFunc ' %GRID:10,7,1,1
				GroupBox 10,84,450,98,"Output Power Measurement",.GroupBox1
				GroupBox 10,189,450,63,"Options",.GroupBox2
				ListBox 20,105,430,70,TunerMeas(),.cPoutMeas
				OKButton 250,266,90,21
				CancelButton 350,266,90,21
				Text 20,14,440,56,"A constant output power control block was found.  To successfully perform a constant output power load pull a measurement for the output power must be defined.  Please choose that measurement from the list below, or cancel and add a new one.",.Text1
				Text 30,210,280,14,"Output power tolerance (measurement units)",.Text3
				TextBox 320,203,90,21,.cPoutD
			End Dialog
			Dim dlg4 As UserDialog
			func = Dialog(dlg4)

			If (func >= 0) Then
				Exit Function
			End If

			If (IsNumeric(dlg4.cPoutD)) Then
				ConstPoutD = CDbl(getRegionalString(dlg4.cPoutD))
			Else
				giveWarnMsg("Output power tolerance must be a number (instead " + dlg4.cPoutD + ") - Using 0.1")
				ConstPoutD = 0.1
			End If

			Debug.Print "ConstPOUTd = " + CStr(ConstPoutD)

			'For constant output power the output power must be on the measurement list
			foundMatch = False
			For i=0 To UBound(dlg.meas)
				If (dlg.meas(i) = dlg4.cPoutMeas) Then
					foundMatch = True
					Exit For
				End If
			Next i

			If (foundMatch = False) Then
				ReDim Preserve dlg.meas(UBound(dlg.meas)+1)
				dlg.meas(UBound(dlg.meas)) = dlg4.cPoutMeas
			End If

			Exit For
		End If
	Next ele

	Debug.Print "Schematic = " + S.Name
	Debug.Print "Tuner = " + E.Name

	MeasDict.RemoveAll()
	Debug.Print "Measurements..."
	For i=0 To UBound(dlg.meas)
		mName = TunerMeas(dlg.meas(i))
		If ((mName = TunerMeas(dlg4.cPoutMeas)) And (HasConstPout)) Then
			specialName = mName + SPECIAL_MEAS
		Else
			specialName = mName
		End If
		Set MeasDict(specialName) = findMeas(mName)
		measHeaderDict(specialName) = cleanMeasString(mName)
		Debug.Print vbTab + specialName
	Next i

	MeasNameDict.RemoveAll()
	If (dlg.CustomHeader) Then
		userNameDict.RemoveAll()
		If (PropDict.Exists(USER_MEAS_NAMES)) Then
			If (PropDict(USER_MEAS_NAMES) <> "") Then
				toks = Split(PropDict(USER_MEAS_NAMES),SplitChar)
				For i = 0 To UBound(toks)
					mName = Split(toks(i),StrDelim)(0)
					userName = Split(toks(i),StrDelim)(1)
					If (MeasDict.Exists(mName)) And (userName <> "") Then
						userNameDict(mName) = userName
					End If
				Next
			End If
		End If

		meass = ""
		For i = 0 To measHeaderDict.Count - 1
			mCleanName = measHeaderDict.Items(i)
			mName = measHeaderDict.Keys(i)
			If (userNameDict.Exists(mName)) Then
				mCleanName = userNameDict(mName)
			End If
			meass = meass + mCleanName + vbNewLine
		Next

		Begin Dialog UserDialog 760,322,"Custom Load Pull File Header Names" ' %GRID:10,7,1,1
			Text 10,7,740,42,"Replace the header names below with the desired load pull file header names.  Header names cannot be added or removed, only edited.  If the final header count does not match the original header count then the original, auto-generated header names will be used.",.Text1
			CancelButton 660,294,90,21
			OKButton 570,294,90,21
			TextBox 10,49,740,238,.meass,1
		End Dialog
		Dim dlg5 As UserDialog
		dlg5.meass = meass
		func = Dialog(dlg5)

		If (func <> 0) Then
			userNameDict.RemoveAll()
			toks = Split(dlg5.meass,vbNewLine)
			For i = 0 To UBound(toks)
				userName = toks(i)
				If (userName <> "") Then
					userNameDict(userName) = userName
				End If
			Next
			If (userNameDict.Count = measHeaderDict.Count) Then
				For i = 0 To MeasDict.Count - 1
					userName = userNameDict.Keys(i)
					mName = measHeaderDict.Keys(i)
					MeasNameDict(mName) = userName
					userNames = userNames + mName + StrDelim + userName
					If (i <> MeasDict.Count - 1) Then
						userNames = userNames + SplitChar
					End If
				Next
			End If
		End If
	End If

	PropDict(USER_MEAS_NAMES) = userNames
	saveUserOpts("")

	If (MeasNameDict.Count = 0) Then
		For i = 0 To measHeaderDict.Count - 1
			mName = measHeaderDict.Keys(i)
			MeasNameDict(mName) = cleanMeasString(mName)
		Next
	End If

	UseIterative = dlg.useIterative

	HarmonicVal = dlg.harmonic + 1

	Debug.Print "Use iterative = " + CStr(UseIterative)
	Debug.Print "Use harmonic = " + CStr(HarmonicVal)
	Debug.Print "Plot contours = " + CStr(PlotContours)
	Debug.Print "Plot contours max = " + CStr(PlotContoursMax)
	Debug.Print "Plot contours min = " + CStr(PlotContoursMin)

	LoadPullDFName = dlg.fName
	LoadPullGName = dlg.gName

	'Any measurements that point to the LoadPullDFName could be a problem in tune mode
	'and the graph gets recreated anyway.  So for right now remove all the measurements on it.
	If (AddGraphs) Then
		If (Project.Graphs.Exists(LoadPullGName)) Then
			'Project.Graphs.Remove(LoadPullGName)
			Project.Graphs(LoadPullGName).Measurements.RemoveAll()
		End If
	End If

	Set lpgs = Project.Graphs
	For Each lpg In lpgs
		Set lpms = lpg.Measurements
		For Each lpm In lpms
			If (lpm.Source = LoadPullDFName) And (lpm.Enabled) Then
				Set LPMeasDict(lpg.Name + SplitChar + lpm.Name) = lpm
				lpm.Enabled = False
			End If
		Next lpm
	Next lpg

	Debug.Print "Load Pull Data File Name = " + LoadPullDFName
	Debug.Print "Load Pull Graph Name = " + LoadPullGName
	Debug.Print

End Function
Function resimLPContours() As Boolean

	Dim df As DataFile
	Dim dfs As DataFiles
	Dim i As Integer
	Dim sf As SimulationFilter
	Dim toks() As String

	For i=0 To LPMeasDict.Count - 1
		toks = Split(LPMeasDict.Keys(i),SplitChar)
		findAndEnableMeas(toks(0),toks(1))
	Next i

	If (Project.SimulationFilters.Exists(SFName)) Then
		Project.SimulationFilters.Remove(SFName)
	End If
	Set sf = Project.SimulationFilters.Add(SFName)
	sf.Enabled = True
	sf.DocNameRemove("*")
	sf.DocNameAdd(S.Name)

	Set dfs = Project.DataFiles
	For Each df In dfs
		If (InStr(df.Filename,".sp")) Or (InStr(df.Filename,".lp")) Or (InStr(df.Name,FAILED_POINTS)) Then
			sf.DocNameAdd(df.Name)
		End If
	Next df

	Project.Simulator.Analyze()
	Project.SimulationFilters.Remove(SFName)

End Function
Function giveErrMsg(msg As String) As Integer

	Dim func As Integer

	If (TestMode) Then
		Debug.Print msg
	Else
		func = MsgBox(msg,vbOkOnly,"Script Error")
	End If

	StatusDict(msg) = MWOffice.mwRIC_Error

	giveErrMsg = func

End Function
Function giveWarnMsg(msg As String) As Integer

	Dim func As Integer

	If (TestMode) Then
		Debug.Print msg
	Else
		func = MsgBox(msg,vbOkOnly,"Script Warning")
	End If

	'StatusDict(msg) = MWOffice.mwRIC_Warning

	giveWarnMsg = func

End Function
Function giveInfoMsg(msg As String) As Integer

	Dim func As Integer

	If (TestMode) Then
		Debug.Print msg
	Else
		func = MsgBox(msg,vbOkOnly,"Script Info")
	End If

	'StatusDict(msg) = MWOffice.mwRIC_Info

	giveInfoMsg = func

End Function
Function giveYesNoMsg(msg As String) As Integer

	Dim func As Integer

	If (TestMode) Then
		Debug.Print msg
	Else
		func = MsgBox(msg,vbYesNo,"Script Info")
	End If

	giveYesNoMsg = func

End Function
Function getCalculatedPoints(writeGraph As Boolean) As Boolean

	Dim i As Integer
	Dim j As Integer
	Dim n As Integer
	Dim cx As Double
	Dim cy As Double
	Dim cm As Double
	Dim ca As Double
	Dim cr As Double
	Dim ci As Double
	Dim p As Double
	Dim ss As Double
	Dim acr As Double
	Dim mcr As Double
	Dim df As DataFile
	Dim lppt As pt

	PointDict.RemoveAll()

	acr = degToRad(AC)
	cx = MC*Cos(acr)
	cy = MC*Sin(acr)

	Debug.Print "Radius = " + CStr(Rad)
	Debug.Print "Center Magnitude = " + CStr(MC)
	Debug.Print "Center Angle = " + CStr(AC)
	If (MD = LP_MODE_SQUARE) Then
		Debug.Print "Number of rows / cols = " + CStr(NMC)
	Else
		Debug.Print "Number of Circles = " + CStr(NMC)
	End If
	Debug.Print "Number of Circle Points = " + CStr(PPC)
	Debug.Print "Mode = " + CStr(MD)
	Debug.Print

	n = 0
	If (MD = LP_MODE_FIXED_ANGLE) Then
		lppt.r = cx
		lppt.i = cy
		PointDict(n) = lppt
		n = n + 1
		For i = 1 To NMC
			cm = i*Rad/NMC
			p = PPC*i
			For j = 1 To p
				ca = j*2*PI/p
				cr = cm*Cos(ca) + cx
				ci = cm*Sin(ca) + cy
				mcr = Sqr(cr*cr + ci*ci)
				If (mcr < MagMax) Then
					lppt.r = cr
					lppt.i = ci
					PointDict(n) = lppt
					n = n + 1
				End If
			Next j
		Next i
	ElseIf (MD = LP_MODE_FIXED_NPTS) Then
		lppt.r = cx
		lppt.i = cy
		PointDict(n) = lppt
		n = n + 1
		For i = 1 To NMC
			cm = i*Rad/NMC
			For j = 1 To PPC
				ca = j*2*PI/PPC
				cr = cm*Cos(ca) + cx
				ci = cm*Sin(ca) + cy
				mcr = Sqr(cr*cr + ci*ci)
				If (mcr < MagMax) Then
					lppt.r = cr
					lppt.i = ci
					PointDict(n) = lppt
					n = n + 1
				End If
			Next j
		Next i
	ElseIf (MD = LP_MODE_SQUARE) Then
		'lppt.r = cx
		'lppt.i = cy
		'PointDict(n) = lppt
		'n = n + 1
		ss = Rad*2/(NMC-1)
		For i = 0 To NMC - 1
			cr = cx-Rad+(ss*i)
			For j = 0 To NMC - 1
				ci = cy-Rad+(ss*j)
				mcr = Sqr(cr*cr + ci*ci)
				If (mcr < MagMax) Then
					lppt.r = cr
					lppt.i = ci
					PointDict(n) = lppt
					n = n + 1
				End If
			Next j
		Next i
	End If

	If (writeGraph) Then
		drawPointsOnGraph(True,False)
	End If

End Function
Function fillPointArrays() As Boolean

	Dim i As Integer
	Dim n As Integer
	Dim lppt As pt

	n = PointDict.Count-1

	ReDim Reals(n)
	ReDim Imags(n)
	For i=0 To n
		lppt = PointDict(i)
		Reals(i) = lppt.r
		Imags(i) = lppt.i
	Next i

End Function
Function getLoadPullDataFile(dfName As String) As Boolean

	Dim failName As String

	If (Project.DataFiles.Exists(dfName)) Then
		Project.DataFiles.Remove(dfName)
	End If
	Set LPDF = Project.DataFiles.Add(dfName,dfName+".lp",True,mwDFT_TXT)

	If (PlotFailedPnts) Then
		failName = LPDF.Name + FAILED_POINTS
		If (Project.DataFiles.Exists(failName)) Then
			Project.DataFiles.Remove(failName)
		End If
		Set LPFailDF = Project.DataFiles.Add(failName,failName+".txt",True,mwDFT_TXT)
	End If

	LoadPullDFDict(dfName) = dfName

End Function
Function getGraph() As Boolean

	If (Project.Graphs.Exists(GName)) Then
		Project.Graphs.Remove(GName)
	End If

	Set G = Project.Graphs.Add(GName,mwGT_SmithChart)
	G.Windows(1).WindowState = mwWS_Minimized

End Function
Function clearGraph() As Boolean

	Dim ds As DrawingShape
	Dim dss As DrawingShapes
	Dim i As Integer

	Set dss = G.DrawingShapes
	For Each ds In dss
		ds.Delete
	Next ds

	G.Measurements.RemoveAll()

End Function
Function drawPointsOnGraph(useCircle As Boolean, drawShapes As Boolean) As Boolean

	Dim a As Attribute
	Dim x As Double
	Dim y As Double
	Dim i As Integer
	Dim n As Integer
	Dim lpm As Measurement
	Dim tr As Trace
	Dim sf As SimulationFilter
	Dim swp As Sweeper

	fillPointArrays()

	'If circles aren't used then user is trying to draw a point on top of another one
	If (useCircle) Then
		clearGraph()
	End If

	n = UBound(Reals)
	If (drawShapes) Then
		For i=0 To n
			drawPointOnGraph(Reals(i),Imags(i),useCircle, False, False)
		Next i
	Else
		If (G.Windows.Count = 0) Then
			G.NewWindow()
		End If
		If (G.Measurements.Count = 0) Then
			G.Windows(1).WindowState = mwWS_Minimized
			Set lpm = addAPIMeas()
		Else
			G.Windows(1).WindowState = mwWS_Minimized
			Set lpm = G.Measurements(1)
		End If
		Set tr = G.Traces(1)
		tr.SymbolSize = 4
		tr.SymbolInterval = 1
		tr.FrequencyArrows = False
		tr.Color = 16711680
		tr.Visible = False
		tr.SymbolVisible = True
		tr.Weight = mwThin
		If (useCircle) Then
			tr.Symbol  = mwSymbolCircle
		Else
			tr.Symbol = mwSymbolSquare
		End If

		If (G.Windows(1).WindowState = mwWS_Minimized) Then
			G.Windows(1).WindowState = mwWS_Normal
		End If

		lpm.ResizeFor2D(n+1,2)
		lpm.XValues = Reals
		lpm.YValues(1) = Reals
		lpm.YValues(2) = Imags
		lpm.Update()

		If (Project.SimulationFilters.Exists(SFName)) Then
			Project.SimulationFilters.Remove(SFName)
		End If
		Set sf = Project.SimulationFilters.Add(SFName)
		sf.DocNameRemove("*")
		sf.Enabled = True
		Set swp = Project.Sweeper
		swp.Update(True,True)
		Project.SimulationFilters.Remove(SFName)
	End If

End Function
Function addAPIMeas() As Measurement

	Set addAPIMeas = G.Measurements.Add("LoadPull","API")

End Function

Function drawPointOnGraph(re As Double, im As Double, useCircle As Boolean, useLeftSlash As Boolean, useRightSlash As Boolean) As DrawingShape

	Dim ds As DrawingShape
	Dim x As Double
	Dim y As Double

	x = G.GridToLogicalCoordinateX(re)
	y = G.GridToLogicalCoordinateY(im)
	If (useCircle) Then
		Set ds = G.DrawingShapes.AddEllipse(x-MarkerRad,y+MarkerRad,x+MarkerRad,y-MarkerRad)
	ElseIf (useLeftSlash) Then
		Set ds = G.DrawingShapes.AddLine(x-MarkerRad,y-MarkerRad,x+MarkerRad,y+MarkerRad)
	ElseIf (useRightSlash) Then
		Set ds = G.DrawingShapes.AddLine(x-MarkerRad,y+MarkerRad,x+MarkerRad,y-MarkerRad)
	Else
		Set ds = G.DrawingShapes.AddRectangle(x-MarkerRad,y+MarkerRad,x+MarkerRad,y-MarkerRad)
	End If

	Set drawPointOnGraph = ds

End Function
Function getPointsFromGraph(ByRef hasErr As Boolean) As Boolean

	Dim ds As DrawingShape
	Dim dss As DrawingShapes
	Dim cr As Double
	Dim ci As Double
	Dim n As Integer
	Dim func As Integer
	Dim lppt As pt

	hasErr = False

	Begin Dialog UserDialog 360,161,"Edit Impedance Points" ' %GRID:10,7,1,1
		Text 20,7,240,14,"Points on graph can now be edited...",.Text1
		Text 20,28,270,14,"- Select and delete points to remove them",.Text2
		Text 20,49,320,14,"- Copy and paste existing points to add new ones",.Text3
		Text 20,70,320,14,"- Bring this window back to focus and press OK",.Text4
		Text 30,84,320,14,"when finished.",.Text5
		OKButton 70,126,90,21
		CancelButton 180,126,90,21
	End Dialog
	Dim dlg As UserDialog
	func = Dialog(dlg)

	If (func = 0) Then
		scriptEnd()
	End If

	If (checkHasEnoughPoints = False) Then
		hasErr = True
		giveErrMsg("At least 4 points are needed for load pull")
		drawPointsOnGraph(True,True)
		Exit Function
	End If

	PointDict.RemoveAll()

	n = 0
	Set dss = G.DrawingShapes
	For Each ds In dss
		If (ds.Type = mwDST_Ellipse) Then
			cr = G.LogicalToGridCoordinateX(ds.BasePosition.x+MarkerRad)
			ci = G.LogicalToGridCoordinateY(ds.BasePosition.y-MarkerRad)
			lppt.r = cr
			lppt.i = ci
			PointDict(n) = lppt
			n = n + 1
		End If
	Next ds

	'reorderPoints()

	drawPointsOnGraph(False, False)

End Function
Function checkHasEnoughPoints() As Boolean

	Dim ret As Boolean

	If (G.DrawingShapes.Count < 4) Then
		ret = False
	Else
		ret = True
	End If

	checkHasEnoughPoints = ret

End Function
Function reorderPointsEx() As Boolean

	Dim re As Double
	Dim im As Double
	Dim mag As Double
	Dim ang As Double
	Dim pointArray() As Double
	Dim tempDict As Dictionary
	Dim toks() As String
	Dim i As Integer
	Dim n As Integer
	Dim lppt As pt

	Set tempDict = New Dictionary

	n = PointDict.Count-1

	ReDim pointArray(n)

	For i=0 To n
		re = PointDict.Keys(i)
		im = PointDict.Items(i)
		mag = getMagFromRI(re,im)
		ang = getAngFromRI(re,im)
		tempDict(mag) = ang
		pointArray(i) = mag
	Next i

	alphaSort(pointArray)

	PointDict.RemoveAll()

	For i=0 To n
		mag = pointArray(i)
		ang = tempDict(mag)
		ang = degToRad(ang)
		Debug.Print CStr(mag) + vbTab + CStr(ang)
		re = mag*Cos(ang)
		im = mag*Sin(ang)
		lppt.r = re
		lppt.i = im
		PointDict(n) = lppt
	Next i

End Function
Function getPointsFromLPFile(runSilent As Boolean) As Boolean

	Dim df As DataFile
	Dim dfLines() As String
	Dim dfVals() As String
	Dim foundPoints As Boolean
	Dim i As Integer
	Dim lpg As Graph
	Dim lpgName As String
	Dim lpm As Measurement
	Dim lppt As pt
	Dim mName As String
	Dim sf As SimulationFilter
	Dim swp As Sweeper
	Dim tr As Trace

	foundPoints = True

	lpgName = SFName
	Set lpg = G
	G.Windows(1).WindowState = mwWS_Minimized

	'Pick a graph, any graph, the user doesn't need to see this...
	PointDict.RemoveAll()

	If (ExistingFile = "") Then
		If (runSilent = False) Then
			giveErrMsg("No impdeance files in the project!")
			scriptEnd()
		Else
			clearGraph()
			Exit Function
		End If
	End If

	Set df = Project.DataFiles(ExistingFile)

	If (df.DataAsText = "") Then
		If (runSilent = False) Then
			giveErrMsg("Impedance data file contains no data!")
			scriptEnd()
		Else
			clearGraph()
			Exit Function
		End If
	End If

	If (InStr(df.Filename,".txt")) Then
		Set lpm = lpg.Measurements.Add(ExistingFile,"LPGPT(50,0,50,0)")
	Else
		Set lpm = lpg.Measurements.Add(ExistingFile,"LPGPM(1,50,0)")
	End If
	Set sf = Project.SimulationFilters.Add(SFName)
	sf.DocNameRemove("*")
	sf.DocNameAdd(ExistingFile)
	sf.Enabled = True
	Set swp = Project.Sweeper
	swp.Update(True,True)
	Project.SimulationFilters.Remove(SFName)
	If (checkSimErrors(df.Name,True)) Then
		'First remove the existing "fake" measurement
		lpg.Measurements.Remove(lpm.Name)
		Set lpm = addAPIMeas()
		lpm.ResizeFor2D(1,1)
		lpm.Update()
		giveErrMsg("A simulation error occured, this is not a valid data file")
		Exit Function
	End If
	For i = 1 To lpm.XPointCount
		lppt.r = lpm.YValue(i,1)
		lppt.i = lpm.YValue(i,2)
		PointDict(i-1) = lppt
	Next i

	lpg.Measurements.Remove(lpm.Name)
	drawPointsOnGraph(True,False)

End Function
Function manageSweeps() As Boolean

	Dim freq As Double
	Dim swpVals() As Double
	Dim swpVal As Double
	Dim swpName As String
	Dim origEq As String
	Dim newEq As String
	Dim ele As Element
	Dim i As Integer
	Dim j As Integer
	Dim k As Integer
	Dim dfName As String
	Dim header As String
	Dim msg As String
	Dim func As Integer
	Dim nVals As Integer
	Dim pnVals As Integer
	Dim nSwps As Integer
	Dim nSwpValues As Integer
	Dim swpDict As Dictionary
	Dim temp() As Integer
	Dim swpIndices()
	Dim freqs()
	Dim origS As Schematic
	Dim origE As Element

	Set swpDict = New Dictionary

	If (SwpCount > 1) Then
		MultiPoint = True
		If (PerformMultiple = False) Then
			msg = "Project has " + CStr(SwpCount) + " sweep points - continuing will require running " + CStr(SwpCount) + " load pull simulations and generating " + CStr(SwpCount) + " data files."
			msg = msg + vbLf + vbLf + "Do you want to continue?"
			func = giveYesNoMsg(msg)
			If (func = 7) Then
				scriptEnd()
			End If
		End If

		If ((S.UseProjectFrequencies) And (S.Frequencies.Count > 1)) Then
			msg = "Multiple frequency simulation requires that the scheamtic use local (i.e. not project) frequencies.  Please fix and rerun the load pull script"
			func = giveErrMsg(msg)
			scriptEnd()
		End If

		ReDim swps(0)
		'First set all the variables to the first value of the sweep
		For i=0 To SwpPntDict.Count - 1
			swpName = SwpPntDict.Keys(i)
			swpVals = SwpPntDict.Items(i)
			If (UBound(swpVals) > 0) Then
				swpDict(swpName) = swpVals
			End If
			setEquation(swpName,swpVals(0),newEq,origEq)
			SwpValDict(swpName) = origEq
			'Debug.Print "Orig Eqn: " + origEq
			'Debug.Print "New Eqn: " + newEq
		Next i

		'Allocate sweep index array
		nSwpValues = (SwpCount/S.Frequencies.Count) - 1
		nSwps = swpDict.Count - 1
		If (nSwpValues >= 0) Then
			ReDim swpIndices(nSwpValues)
		End If
		If (nSwps >= 0) Then
			ReDim temp(nSwps)
		End If
		For i=0 To nSwpValues
			swpIndices(i) = temp
		Next i

		'Parse through each sweep and come up with the index for each sweep variable
		nVals = 1
		pnVals = 1
		For i=0 To nSwps
			swpVals = swpDict.Items(i)
			nVals = nVals * (UBound(swpVals) + 1)
			k = 0
			'Debug.Print "Sweep: " + CStr(i)
			For j=0 To nSwpValues
				temp = swpIndices(j)
				If ((j+1) Mod nVals = 0) Then
					'Debug.Print vbTab + CStr(k)
					temp(i) = k
					k = 0
				Else
					If ((j+1) Mod pnVals = 0) Then
						'Debug.Print vbTab + CStr(k)
						temp(i) = k
						k = k + 1
					Else
						'Debug.Print vbTab + CStr(k)
						temp(i) = k
					End If
				End If
				swpIndices(j) = temp
			Next j
			pnVals = nVals
		Next i

		'Iterate through each sweep condition, set the variables, and run the simulations
		Debug.Print
		CurSwp = 1
		freqs = FreqPntDict.Items
		For i=0 To UBound(freqs)
			freq = freqs(i)
			'Can't set frequencies if they are global but since only one frequency should run the parameter sweep
			If (S.UseProjectFrequencies = False) Then
				S.Frequencies.Clear
				S.Frequencies.Add(freq)
			End If

			If (nSwpValues < 0) Then
				getDFName(dfName,header,freq,msg)
				Debug.Print "Sweep: " + CStr(CurSwp)
				If (SweepTestMode = False) Then
					If (SupportMode) Then
						Set origS = S
						Set S = Project.Schematics.Copy(S.Name,getNewSName(""))
						Set origE = E
						Set E = S.Elements(E.Name)
						redirectMeas()
					End If
					doLoadPull("","")
					If (SupportMode) Then
						Set S = origS
						Set E = origE
						redirectMeas()
					End If
					removeStuffFromSchem(False)
				End If
				CurSwp = CurSwp + 1
			Else
				For j=0 To nSwpValues
					temp = swpIndices(j)
					msg = ""
					dfName = ""
					header = ""
					Debug.Print "Sweep: " + CStr(CurSwp)
					For k=0 To nSwps
						swpName = swpDict.Keys(k)
						swpVal = swpDict.Items(k)(temp(k))
						setEquation(swpName,swpVal, newEq, origEq)
						msg = msg + newEq + vbTab
						Debug.Print vbTab + "Freq: " + CStr(freq/1e9) + " GHz"
						Debug.Print vbTab + "Eqn: " + swpName + "=" + CStr(swpVal)
					Next k
					getDFName(dfName,header,freq,msg)
					If (SweepTestMode = False) Then
						If (SupportMode) Then
							Set origS = S
							Set S = Project.Schematics.Copy(S.Name,getNewSName(dfName))
							Set origE = E
							Set E = S.Elements(E.Name)
							redirectMeas()
						End If
						doLoadPull(dfName,header)
						If (SupportMode) Then
							Set S = origS
							Set E = origE
							redirectMeas()
						End If
						removeStuffFromSchem(False)
					End If
					CurSwp = CurSwp + 1
				Next j
			End If
		Next i
	Else
		If (SweepTestMode = False) Then
			CurSwp = 1
			Debug.Print "Sweep: " + CStr(CurSwp)
			If (SupportMode) Then
				Set origS = S
				Set S = Project.Schematics.Copy(S.Name,getNewSName(""))
				Set origE = E
				Set E = S.Elements(E.Name)
				redirectMeas()
			End If
			doLoadPull("","")
			If (SupportMode) Then
				Set S = origS
				Set E = origE
				redirectMeas()
			End If
			removeStuffFromSchem(False)
		End If
	End If

	If (SweepTestMode) Then
		scriptEnd()
	End If

End Function
Function getNewSName(msg As String) As String

	Dim newSName As String
	newSName = S.Name + msg + SupportName

	If (Project.Schematics.Exists(newSName)) Then
		Project.Schematics.Remove(newSName)
	End If

	getNewSName = newSName

End Function
Function redirectMeas() As String

	Dim i As Integer
	Dim isConstPout As Boolean
	Dim lpg As Graph
	Dim lpgName As String
	Dim lpms
	Dim lpm As Measurement
	Dim mName As String
	Dim newMeasDict As New Scripting.Dictionary
	Dim sim As String
	Dim tok As String

	lpms = MeasDict.Items

	Set lpg = Nothing
	If (InStr(S.Name,SupportName)) Then
		lpgName = S.Name
		If (Project.Graphs.Exists(lpgName)) Then
			Project.Graphs.Remove(lpgName)
		End If
		Set lpg = Project.Graphs.Add(lpgName,mwGT_Rectangular)
	End If

	Debug.Print vbTab + "Redirecting Measurements..."

	For i=0 To MeasDict.Count-1
		sim = ""
		isConstPout = False
		Set lpm = lpms(i)
		mName = MeasDict.Keys(i)
		If (isSpecialMeas(mName)) Then
			isConstPout = True
		End If
		tok = S.Name
		If (InStr(mName,".")) Then
			sim = Split(mName,".")(1)
			sim = Split(sim,":")(0)
			tok = tok + "." + sim
		End If
		If (isConstPout) Then
			tok = tok + SPECIAL_MEAS
		End If
		lpm.Source = tok
		Set newMeasDict(lpm.Name) = lpm
		Debug.Print vbTab + vbTab + mName + " -->"
		Debug.Print vbTab + vbTab + vbTab + lpm.Name
		If (lpg Is Nothing = False) Then
			lpg.Measurements.Add(lpm.Source,lpm.Type)
		End If
	Next i

	MeasDict.RemoveAll()
	lpms = newMeasDict.Items
	For i = 0 To newMeasDict.Count - 1
		mName = newMeasDict.Keys(i)
		Set lpm = lpms(i)
		Set MeasDict(mName) = lpm
	Next i

End Function
Function getDFName(dfName As String, header As String, freq As Double, swpInfo As String) As Boolean

	Dim swpVal As String
	Dim swpName As String
	Dim freqG As String
	Dim toks() As String
	Dim i As Integer

	freqG = stringReplace(CStr(freq/1e9),".","_")

	header = "!Freq: " + freqG + " GHz" + vbTab
	dfName = "_" + freqG + "_GHz"

	toks = Split(swpInfo,vbTab)
	For i=0 To UBound(toks) - 1
		swpName = Split(toks(i),"=")(0)
		swpVal = Split(toks(i),"=")(1)
		swpVal = Replace(swpVal,".","_")
		swpVal = Replace(swpVal,"-","_")
		dfName = dfName + "_" + swpName
		dfName = dfName + "_"+ CStr(swpVal)
		header = header + swpName + ": "
		header = header + CStr(swpVal) + vbTab + vbTab
	Next i

End Function
Function doLoadPull (dfName As String, swpInfo As String) As Boolean

	Dim re As Double
	Dim im As Double
	Dim mag As Double
	Dim ang As Double
	Dim ds As DrawingShape
	Dim ds1 As DrawingShape
	Dim ds2 As DrawingShape
	Dim eq As Equation
	Dim Tuner As Sweeper
	Dim tStart As Double
	Dim tStop As Double
	Dim sf As SimulationFilter
	Dim i As Integer
	Dim n As Integer
	Dim func As Integer

	If (InStr(E.Name,"HB")) Then
		Set MagParam = E.Parameters("Mag"+CStr(HarmonicVal))
		Set AngParam = E.Parameters("Ang"+CStr(HarmonicVal))
	Else
		Set MagParam = E.Parameters("Mag")
		Set AngParam = E.Parameters("Ang")
	End If

	OrigMag = MagParam.ValueAsString
	OrigAng = AngParam.ValueAsString

	n = UBound(Reals)

	If (Project.SimulationFilters.Exists(SFName)) Then
		Project.SimulationFilters.Remove(SFName)
	End If
	Set sf = Project.SimulationFilters.Add(SFName)
	sf.DocNameRemove("*")
	sf.DocNameAdd(S.Name)
	sf.Enabled = True

	'Make sure there are always points on the grah
	If ((EditPoints) And (G.DrawingShapes.Count = 0)) Or (G.Measurements.Count = 0) Then
		drawPointsOnGraph(True,False)
	End If
	MarkerRad = 50

	If (MultiPoint) Then
		dfName = LoadPullDFName + dfName
	Else
		dfName = LoadPullDFName
	End If

	FailedPntDict.RemoveAll()
	getLoadPullDataFile(dfName)
	writeLPHeader(swpInfo)

	tStart = Timer()

	If (UseIterative) Then
		closeGraphWindows()
		writeStuffToSchem()
		MagParam.ValueAsString = "awr_load_pull_mags[awr_load_pull_index]"
		AngParam.ValueAsString = "awr_load_pull_angs[awr_load_pull_index]"
		Project.Simulator.Analyze()
		If (writeLPData(0,0) = False) Then
			Debug.Print "Sim Error: " + dfName
			LoadPullDFDict.Remove(dfName)
		End If
	Else
		Set Tuner = Project.Sweeper
		Tuner.AddVariable("m",MagParam)
		Tuner.AddVariable("a",AngParam)
		For i=0 To n
			re = Reals(i)
			im = Imags(i)
			mag = getMagFromRI(re,im)
			ang = getAngFromRI(re,im)
			Debug.Print vbTab + "Index,Mag,Ang = (" + CStr(i) + ", " + CStr(mag) + ", " + CStr(ang) + ")"
			Set ds = drawPointOnGraph(re,im,True, False, False)
			Tuner.Value("m") = mag
			Tuner.Value("a") = degToRad(ang)
			Tuner.Update(True,True)
			If (writeLPData(re,im) = False) Then
				Set ds1 = drawPointOnGraph(re,im,False,True,False)
				Set ds2 = drawPointOnGraph(re,im,False,False,True)
				Wait 1
				ds1.Delete()
				ds2.Delete()
			End If
			ds.Delete()
		Next i
		closeGraphWindows()
	End If

	tStop = Timer()
	Debug.Print "Sim Time: " + CStr(tStop - tStart) + " seconds"

	fixLPFile(LPDF)

	writeFailedPoints()

	Project.SimulationFilters.Remove(SFName)

End Function
Function setEquation(eqName As String, eqValue As Double, ByRef newExpr As String, ByRef origExpr As String) As Boolean

	Dim eq As Equation
	Dim eqs As Equations
	Dim ex As String
	Dim i As Integer
	Dim l As String
	Dim r As String
	Dim msg As String
	Dim foundEq As Boolean

	origExpr = ""
	foundEq = False

	Set eqs = S.Equations
	For Each eq In eqs
		If (eq.Enabled) Then
			For i=1 To eq.NumSubexpressions
				ex = eq.Subexpression(i)
				If (InStr(ex,"=")) Then
					getLeftAndRightEqSides(ex,l,r)
					If ((IsNumeric(r)) And (l = eqName)) Then
						foundEq = True
						origExpr = ex
						newExpr = eqName + "=" + CStr(eqValue)
						eq.Subexpression(i) = newExpr
						Exit For
					End If
				End If
			Next i
		End If
		If (foundEq) Then
			Exit For
		End If
	Next eq

	If (foundEq = False) Then
		giveErrMsg("The variable definition for " + eqName + " is either missing or in error")
		scriptEnd()
	End If

End Function
Function getSweeps() As Boolean

	Dim foundMatch As Boolean
	Dim freq As Frequency
	Dim freqs As Frequencies
	Dim i As Integer
	Dim j As Integer
	Dim msg As String
	Dim swp As SweepVariable
	Dim swpEqn As Equation
	Dim vals() As Double

	Set freqs = S.Frequencies
	For Each freq In freqs
		FreqPntDict(freq.Value) = freq.Value
	Next freq

	SwpCount = S.Frequencies.Count
	For i=1 To S.SweepVariables.Count
		If (S.SweepVariables(i).Name <> "Freq") Then
			If (S.SweepVariables(i).Values.Count = 1) Then
				msg = "Single-value sweeps are not supported with Load_Pull.  Please disable the SWPVAR block, set the variable equation to the desired value, and run Load_Pull again."
				giveErrMsg(msg)
				scriptEnd()
			End If

			SwpCount = SwpCount * S.SweepVariables(i).Values.Count
			ReDim vals(S.SweepVariables(i).Values.Count-1)
			For j=0 To UBound(vals)
				vals(j) = S.SweepVariables(i).Values(j+1).ValueAsDouble
			Next j
			SwpPntDict(S.SweepVariables(i).Name) = vals
		End If
	Next i

End Function
Function addCountoursToGraph() As Boolean

	Dim dfName As String
	Dim dfFailName As String
	Dim lpgName As String
	Dim i As Integer
	Dim j As Integer
	Dim lpg As Graph
	Dim lpgs
	Dim lpm As Measurement
	Dim lpms
	Dim m As Measurement
	Dim ms As Measurements
	Dim markerDict As New Dictionary
	Dim mCount As Integer
	Dim mIndex As Integer
	Dim mIndexS As String
	Dim mMax As Double
	Dim mMaxS As String
	Dim mMin As Double
	Dim mMinS As String
	Dim mName As String
	Dim mString As String
	Dim mStep As Double
	Dim mStepS As String
	Dim rndL As Integer
	Dim n As Integer
	Dim tr As Trace
	Dim trColor As Long

	If (AddGraphs = False) Then
		Debug.Print
		Debug.Print "Skipping Graphs..."
		Exit Function
	Else
		Debug.Print
		Debug.Print "Adding Graphs..."
	End If

	If (MultiPoint) Then
		n = LoadPullDFDict.Count - 1
	Else
		n = 0
		Set lpg = addGraph(LoadPullGName)
	End If
	
	If (TestMode) Then
		rndL = 0
	Else
		rndL = 2
	End If

	For j=0 To n
		If (MultiPoint) Then
			lpgName = LoadPullGName + "_" + LoadPullDFDict.Keys(j)
			dfName = LoadPullDFDict.Keys(j)
			dfFailName = dfName + FAILED_POINTS
		Else
			lpgName = LoadPullGName
			dfName = LoadPullDFName
			dfFailName = dfName + FAILED_POINTS
		End If

		Debug.Print vbTab + lpgName
		Set lpg = addGraph(lpgName)
		'lpg.Markers.Options.EnableParameterMarkers = False
		lpg.Markers.Options.MarkerSymbol = mwMST_None

		mCount = 0
		For i=0 To MeasNameDict.Count-1
			mString = MeasNameDict.Keys(i)
			If (isSpecialMeas(mString) = False) Then
				'These dictionaries contain min and max for each file with an index of fileNum*MeasIndex
				mIndex = i+MeasDict.Count*j
				mIndexS = CStr(mIndex)
				mMax = Round(MaxDict.Items(mIndex),rndL)
				mMaxS = fixDelimiter(CStr(mMax))
				mMin = Round(MinDict.Items(mIndex),rndL)
				mMinS = fixDelimiter(CStr(mMin))
				If (mMax = mMin) Then
					Debug.Print "Skipped: " + mString
				Else
					If (PlotContours) Then
						mCount = mCount + 1
						mStep = Round((mMax-mMin)/10,rndL)
						If (mStep < 0.01) Then
							mStep = 0.01
						End If
						mStepS = fixDelimiter(CStr(mStep))
						Debug.Print vbTab + vbTab + mIndexS + vbTab + "LPCM" + vbTab + mString + vbTab + mMinS + vbTab + mMaxS + vbTab + mStepS
						mName = "LPCM(" + mMaxS + "," + mMinS + "," + mStepS + "," + CStr(i+1) + ",1,50,0)"
						Set lpm = lpg.Measurements.Add(dfName,mName)
						Set tr = lpg.Traces(lpg.Traces.Count)
						tr.Weight = mwHairline
						tr.LegendText = MeasNameDict(mString)
						tr.LegendText2 = " "
						trColor = tr.Color
					End If
					If (PlotContoursMax) Then
						mCount = mCount + 1
						Debug.Print vbTab + vbTab + mIndexS + vbTab + "LPCMMAX" + vbTab + mString
						mName = "LPCMMAX(" + CStr(i+1) + ",1,50,0)"
						Set lpm = lpg.Measurements.Add(dfName,mName)
						Set tr = lpg.Traces(lpg.Traces.Count)
						tr.SymbolSize = 5
						tr.Weight = mwFat
						tr.Symbol = mwSymbolCircle
						tr.Color = trColor
						tr.LegendText = MeasNameDict(mString) + " Max"
						tr.LegendText2 = " "
						Set markerDict(lpm) = lpg
					End If
					If (PlotContoursMin) Then
						mCount = mCount + 1
						Debug.Print vbTab + vbTab + mIndexS + vbTab + "LPCMMIN" + vbTab + mString
						mName = "LPCMMIN(" + CStr(i+1) + ",1,50,0)"
						Set lpm = lpg.Measurements.Add(dfName,mName)
						Set tr = lpg.Traces(lpg.Traces.Count)
						tr.SymbolSize = 5
						tr.Weight = mwFat
						tr.Symbol = mwSymbolCircle
						tr.Color = trColor
						tr.LegendText = MeasNameDict(mString) + " Min"
						tr.LegendText2 = " "
						Set markerDict(lpm) = lpg
					End If
				End If
			Else
				Debug.Print "Skipped: " + MeasDict.Keys(i)
			End If
		Next i
		If (PlotConvergedPnts) Then
			Debug.Print vbTab + vbTab + mIndexS + vbTab + "LPGPM" + vbTab + dfName
			mName = "LPGPM(1,50,0)"
			Set lpm = lpg.Measurements.Add(dfName,mName)
			Set tr = lpg.Traces(lpg.Traces.Count)
			tr.SymbolIntervalAuto = False
			tr.SymbolInterval = 1
			tr.SymbolSize = 3
			tr.Weight = mwThin
			tr.Symbol = mwSymbolSmallX
			tr.Color = 12632256
			tr.LegendText = "Converged Points"
			tr.LegendText2 = " "
		End If
		If (PlotFailedPnts) And (Project.DataFiles.Exists(dfFailName)) Then
			Debug.Print vbTab + vbTab + mIndexS + vbTab + "LPGPT" + vbTab + dfFailName
			mName = "LPGPT(50,0,50,0)"
			Set lpm = lpg.Measurements.Add(dfFailName,mName)
			Set tr = lpg.Traces(lpg.Traces.Count)
			tr.SymbolIntervalAuto = False
			tr.SymbolInterval = 1
			tr.SymbolSize = 3
			tr.Weight = mwThin
			tr.Symbol = mwSymbolCross
			tr.Color = 0
			tr.LegendText = "Failed Points"
			tr.LegendText2 = " "
		End If
	Next j

	ShouldSim = True

	'lpms = markerDict.Keys
	'lpgs = markerDict.Items
	'For i = 0 To UBound(lpms)
	'	Set lpg = lpgs(i)
	'	Set lpm = lpms(i)
	'	Set ms = lpg.Measurements
	'	For j = 1 To ms.Count
	'		If (lpm.Name = ms(j).Name) Then
	'			lpg.Markers.Add(j,1,1)
	'		End If
	'	Next j
	'Next i

End Function
Function getMeasName(eqn As String) As String

	Dim tok As String

	tok = getRightHalf(eqn,":")
	tok = getLeftHalf(tok,"[")
	tok = cleanString(tok,"DB(")
	tok = cleanString(tok,"Re(")
	tok = cleanString(tok,"Im(")
	tok = cleanString(tok,"Ang(")
	tok = cleanString(tok,"AngU(")
	tok = cleanString(tok,"Conj(")
	tok = cleanString(tok,"|")
	tok = getLeftHalf(tok,"(")

	getMeasName = tok

End Function
Function getMeasArgs(eqn As String) As String

	Dim tok As String

	tok = getRightHalf(eqn,":")
	tok = getLeftHalf(tok,"[")
	tok = cleanString(tok,"DB(")
	tok = cleanString(tok,"Re(")
	tok = cleanString(tok,"Im(")
	tok = cleanString(tok,"Ang(")
	tok = cleanString(tok,"AngU(")
	tok = cleanString(tok,"Conj(")
	tok = cleanString(tok,"|")
	tok = cleanString(tok,getMeasName(eqn) + "(")

	getMeasArgs = tok

End Function
Function getLeftHalf(tok As String, sep As String) As String

	Dim temp As String
	temp = tok

	If (InStr(tok,sep)) Then
		temp = Split(tok,sep)(0)
	End If

	getLeftHalf = temp

End Function
Function getRightHalf(tok As String, sep As String) As String

	Dim temp As String
	temp = tok

	If (InStr(tok,sep)) Then
		temp = Split(tok,sep)(1)
	End If

	getRightHalf = temp

End Function
Function cleanString(tok As String, searchStr As String) As String

	Dim temp As String
	temp = tok

	If (InStr(tok,searchStr)) Then
		temp = Split(tok,searchStr)(1)
		If (Right(tok,1) <> searchStr) Then
		temp = Left(temp,Len(temp)-1)
		End If
	End If

	cleanString = temp

End Function
Function writeFailedPoints() As Boolean

	Dim i As Integer
	Dim msg As String
	Dim pt As pt

	If (PlotFailedPnts) And (FailedPntDict.Count = 0) Then
		If (Project.DataFiles.Exists(LPFailDF.Name)) Then
			Project.DataFiles.Remove(LPFailDF.Name)
		End If
		Exit Function
	End If

	If (PlotFailedPnts = False) Then
		Exit Function
	End If

	msg = "!Impedance points that failed to converge" + vbNewLine
	For i=0 To FailedPntDict.Count-1
		pt = FailedPntDict.Items(i)
		msg = msg + CStr(pt.r) + vbTab + CStr(pt.i) + vbNewLine
	Next i

	LPFailDF.DataAsText = msg
	fixLPFile(LPFailDF)

End Function
Function addGraph(lpgName As String) As Graph

	Dim lpg As Graph

	If (Project.Graphs.Exists(lpgName)) Then
		Project.Graphs(lpgName).Measurements.RemoveAll()
		Set lpg = Project.Graphs(lpgName)
	Else
		Set lpg = Project.Graphs.Add(lpgName,mwGT_SmithChart)
	End If

	Set addGraph = lpg

End Function
Function writeLPData(re As Double, im As Double) As Boolean

	Dim i As Integer
	Dim j As Integer
	Dim n As Integer
	Dim data As Double
	Dim pout As Double
	Dim msg As String
	Dim mName As String
	'Dim lpms()
	Dim lpm As Measurement
	Dim ret As Boolean
	Dim shouldWrite As Boolean

	If (MultiPoint) Then
		If (checkSimErrors(S.Name,True)) Then
			LPDF.DataAsText = LPDF.DataAsText + "!!! SIM ERROR !!!" + vbLf
			writeLPData = False
			Exit Function
		End If
	End If

	writeLPData = True

	'lpms = MeasDict.Items

	If (UseIterative) Then
		checkSimErrors(S.Name,False)
		n = UBound(Reals)
		For i=0 To n
			msg = ""
			re = Reals(i)
			im = Imags(i)
			msg = getDataFromMeas(re,im,i+1,n)
			If (msg <> "") Then
				writeDataToFile(msg)
			End If
		Next i
	Else
		checkSimErrors(S.Name,True)
		msg = getDataFromMeas(re,im,1,0)
		If (msg = "") Then
			writeLPData =False
		Else
			If (msg <> "") Then
				writeDataToFile(msg)
			End If
		End If
	End If


End Function
Function writeDataToFile(ByRef msg As String)

	checkMinMax(msg)
	msg = msg + vbLf
	LPDF.DataAsText = LPDF.DataAsText + msg

End Function
Function getDataFromMeas(re As Double, im As Double, dataPoint As Integer, nPts As Integer) As String

	Dim i As Integer
	Dim data As Double
	Dim lpms()
	Dim lpm As Measurement
	Dim mName As String
	Dim msg As String
	Dim rre As Double
	Dim rim As Double
	Dim pout As Double
	Dim pt As pt
	Dim shouldWrite As Boolean

	lpms = MeasDict.Items
	shouldWrite = True
	rre = Round(re,5.5)
	rim = Round(im,5.5)
	msg = CStr(rre) + vbTab + CStr(rim)

	For i=0 To UBound(lpms)
		Set lpm = lpms(i)
		mName = MeasDict.Keys(i)
		data = getLoadPullDataPoint(lpm,i,dataPoint, nPts)
		If (checkDataRange(data,rre,rim) = False) Then
			shouldWrite = False
		End If
		If (isSpecialMeas(mName)) Then
			pout = data
		End If
		If (shouldWrite) Then
			msg = msg + vbTab + CStr(Round(data,5.10))
		End If
	Next i

	If (checkConstPout(pout,rre,rim) = False) Then
		shouldWrite = False
	End If

	If (shouldWrite = False) Then
		pt.r = rre
		pt.i = rim
		FailedPntDict(FailedPntDict.Count) = pt
		msg = ""
	End If

	getDataFromMeas = msg

End Function
Function isSpecialMeas(mName As String) As Boolean

	isSpecialMeas = False

	If (Right(mName,1) = SPECIAL_MEAS) Then
		isSpecialMeas = True
	End If

End Function
Function checkDataRange (data As Double, re As Double, im As Double) As Boolean

	Dim msg As String
	Dim ret As Boolean

	ret = True
	If (data >= DATA_MAX) Or (data <= -DATA_MAX) Then
		ret = False
		msg = "Discarding point (" + CStr(re) + "," + CStr(im) + ") because of convergence failure
	End If

	If (msg <> "") Then
		Debug.Print msg
		StatusDict(msg) = MWOffice.mwRIC_Warning
	End If

	checkDataRange = ret

End Function
Function checkConstPout (pout As Double, re As Double, im As Double) As Boolean

	Dim ret As Boolean
	Dim mult As Integer
	Dim msg As String

	mult = 2
	msg = ""
	ret = True

	If (HasConstPout) Then
		If (pout > ConstPout-mult*ConstPoutD) And (pout < ConstPout+mult*ConstPoutD) Then
			ret = True
		Else
			ret = False
			msg = "Discarding point (" + CStr(re) + "," + CStr(im) + ") because specified output power"
			msg = msg + "(" + CStr(ConstPout) + " dBm) was not reached (" + CStr(pout) + " dBm)"
		End If
	End If

	If (msg <> "") Then
		Debug.Print msg
		StatusDict(msg) = MWOffice.mwRIC_Warning
	End If

	checkConstPout = ret

End Function
Function fixLPFile(df As DataFile) As String

	'Convert european numbers back to American ones.  This isn't handled
	'automatically by the OS because the numbers in the data files are strings

	Dim msg As String

	msg = df.DataAsText

	If (InStr(msg,",")) Then
		df.DataAsText = fixDelimiter(msg)
	End If

End Function
Function fixDelimiter(tok As String) As String

	fixDelimiter = Replace(tok,",",".")

End Function
Function getAllowedSeparator(tok As String) As String

	getAllowedSeparator = Replace(tok,",",".")

End Function

Function getRegionalString(tok As String) As String

	If (SepIsPeriod) And (InStr(tok,",")) Then
		getRegionalString = Replace(tok,",",".")
	ElseIf (SepIsPeriod = False) And (InStr(tok,".")) Then
		getRegionalString = Replace(tok,".",",")
	Else
		getRegionalString = tok
	End If

End Function
Function getLoadPullDataPoint(lpm As Measurement, mIndex As Integer, lpPoint As Integer, Optional nPts As Integer = 0) As Double

	Dim data As Double

	On Error GoTo getDataPointError

	If (lpm.YDataDim <> (nPts+1)) Then
		giveErrMsg("Dimension changing measurements are not currently supported with load pull, please contact AWR support for additional help.")
		scriptEnd()
	End If

	If (lpm.YDataDim = 0) Then
		giveErrMsg("A simulation error must have occured, there is no measurement data")
		scriptEnd()
	End If

	data = lpm.YValue(1,lpPoint)
	data = fixUnits(data,lpm)

	If (data > DATA_MAX) Then
		data = DATA_MAX
	End If

	getLoadPullDataPoint = data

	Exit Function

getDataPointError:
	If (UseIterative) Then
		giveErrMsg("A simulation error must have occured, there is no measurement data")
		scriptEnd()
	Else
		getLoadPullDataPoint = -DATA_MAX
	End If

	Exit Function

End Function
Function checkMinMax(msg As String)

	Dim toks() As String
	Dim data As Double
	Dim mIndex As Integer
	Dim c As Integer
	Dim i As Integer

	c = 2
	toks = Split(msg,vbTab)
	For i=c To UBound(toks)
		data = CDbl(toks(i))
		mIndex = getMeasIndex(i-c)
		If (data > MaxDict(mIndex)) Then
			MaxDict(mIndex) = data
			'Debug.Print "Max - " + CStr(mIndex) + ": " + CStr(data)
		End If
		If (data < MinDict(mIndex)) Then
			MinDict(mIndex) = data
			'Debug.Print "Min - " + CStr(mIndex) + ": " + CStr(data)
		End If
	Next i

End Function
Function checkSimErrors(dataSource As String, runSilent As Boolean) As Boolean

	Dim st As StatusGroup
	Dim sts As StatusGroups
	Dim si As StatusItem
	Dim sis As StatusItems
	Dim foundErr As Boolean

	foundErr = False

	Set sts = MWOffice.Status.Groups
	For Each st In sts
		If (InStr(st.Name,dataSource)) Then
			Set sis = st.Items
			For Each si In sis
				If (si.Category = mwRIC_Error) Then
					Debug.Print si.Text
					foundErr = True
					If (InStr(si.Text,"User Terminated")) Then
						Debug.Print "User Cancel"
						giveErrMsg("User terminated simulation, no data was recorded")
						scriptEnd()
					End If
				End If
			Next si
		Else
			Set sis = st.Items
			For Each si In sis
				If ((InStr(si.Text,dataSource)) And (si.Category = mwRIC_Error)) Then
					Debug.Print si.Text
					foundErr = True
				End If
			Next si
		End If
	Next st

	If (foundErr) And (runSilent = False) Then
		giveErrMsg("A simulation error occured, no Load Pull data points were written.  Please check the status window, correct the error, and try again")
		scriptEnd()
	Else
		MWOffice.Status.RemoveAllItems()
	End If

	checkSimErrors = foundErr

End Function
Function findAndEnableMeas(graphName As String, measName As String) As Boolean

	Dim lpgs As Graphs
	Dim lpms As Measurements
	Dim lpm As Measurement

	Set lpgs = Project.Graphs
	If (lpgs.Exists(graphName)) Then
		Set lpms = lpgs(graphName).Measurements
		For Each lpm In lpms
			If (lpm.Name = measName) Then
				lpm.Enabled = True
			End If
		Next
	End If

End Function
Function findMeas(measName As String) As Measurement

	Dim lpg As Graph
	Dim lpgs As Graphs
	Dim lpm As Measurement
	Dim lpms As Measurements
	Dim foundMeas As Boolean

	Set lpgs = Project.Graphs
	For Each lpg In lpgs
		Set lpms = lpg.Measurements
		For Each lpm In lpms
			If (lpm.Name = measName) And (lpm.Enabled) Then
				foundMeas = True
				Exit For
			End If
		Next lpm
		If (foundMeas) Then
			Exit For
		End If
	Next lpg

	If (foundMeas = False) Then
		Set lpm = Nothing
	End If

	Set findMeas = lpm

End Function
Function writeLPHeader(swpInfo As String) As Boolean

	Dim i As Integer
	Dim mIndex As Integer
	Dim msg As String

	msg = "! Load Pull Data file for " + S.Name + vbLf
	If (swpInfo <> "") Then
		msg = msg + swpInfo + vbLf
	End If
	msg = msg + "Frequency " + CStr(S.Frequencies(1)/1e9) + " GHz" + vbLf
	msg = msg + "! gamma.x gamma.y"

	For i = 0 To MeasNameDict.Count - 1
		mIndex = getMeasIndex(i)
		MaxDict(mIndex) = -1e6
		MinDict(mIndex) = 1e6
		msg = msg + " " + MeasNameDict.Items(i)
	Next i

	msg = msg + vbLf

	LPDF.DataAsText = msg

End Function
Function getMeasIndex(i As Integer) As Integer

	getMeasIndex = i+(CurSwp-1)*(MeasDict.Count)

End Function
Function cleanMeasString(measName As String) As String

	Dim tok As String
	Dim toks() As String
	Dim tokMod As String
	Dim tokDB As String

	tokMod = ""
	tokDB = ""
	tok = Split(measName,":")(1)

	If (InStr(tok,"DB")) Then
		tok = Split(tok,"DB(")(1)
		tok = Left(tok,Len(tok)-1)
		tokDB = tokDB + "_DB"
	End If

	If (InStr(tok,"Ang")) Then
		tok = Split(tok,"Ang(")(1)
		tok = Left(tok,Len(tok)-1)
		tokMod = tokMod + "_A"
	ElseIf (InStr(tok,"AngU")) Then
		tok = Split(tok,"AngU(")(1)
		tok = Left(tok,Len(tok)-1)
		tokMod = tokMod + "_A"
	ElseIf (InStr(tok,"Re")) Then
		tok = Split(tok,"Re(")(1)
		tok = Left(tok,Len(tok)-1)
		tokMod = tokMod + "_R"
	ElseIf (InStr(tok,"Im")) Then
		tok = Split(tok,"Im(")(1)
		tok = Left(tok,Len(tok)-1)
		tokMod = tokMod + "_I"
	ElseIf (InStr(tok,"|")) Then
		tok = Split(tok,"|")(1)
		tok = Left(tok,Len(tok)-1)
		tokMod = tokMod + "_M"
	End If

	If (InStr(tok,",")) Then
		toks = Split(tok,",")
		tok = toks(0) + "_" + toks(1)
	End If

	tok = stringReplace(tok,"(),.@","_")
	tok = tok + tokMod + tokDB

	If (Right(tok,1) = "_") Then
		tok = Left(tok,Len(tok)-1)
	End If

	cleanMeasString = tok

End Function
Function writeStuffToSchem() As Boolean

	Dim xMax As Double
	Dim yMax As Double
	Dim realMsg As String
	Dim imagMsg As String
	Dim magMsg As String
	Dim angMsg As String
	Dim re As Double
	Dim im As Double
	Dim mag As Double
	Dim ang As Double
	Dim i As Integer
	Dim n As Integer
	Dim swpBlk As Element
	Dim vals As String

	realMsg = "awr_load_pull_reals = {"
	imagMsg = "awr_load_pull_imags = {"
	magMsg = "awr_load_pull_mags = {"
	angMsg = "awr_load_pull_angs = {"

	n = UBound(Reals)

	For i=0 To n
		re = Reals(i)
		im = Imags(i)
		mag = getMagFromRI(re,im)
		ang = getAngFromRI(re,im)
		If ((UseBaseUnits) Or (UseRadians)) Then
			ang = degToRad(ang)
		End If
		Debug.Print vbTab + "Index,Mag,Ang = (" + CStr(i) + ", " + CStr(mag) + ", " + CStr(ang) + ")"
		realMsg = realMsg + fixDelimiter(CStr(re))
		imagMsg = imagMsg + fixDelimiter(CStr(im))
		magMsg = magMsg + fixDelimiter(CStr(mag))
		angMsg = angMsg + fixDelimiter(CStr(ang))
		If (i < n) Then
			realMsg = realMsg + ","
			imagMsg = imagMsg + ","
		magMsg = magMsg + ","
		angMsg = angMsg + ","
		End If
	Next i

	realMsg = realMsg + "}"
	imagMsg = imagMsg + "}"
	magMsg = magMsg +  "}"
	angMsg = angMsg +  "}"

	S.Equations.Add(realMsg,0,-1000)
	S.Equations.Add(imagMsg,0,-900)
	S.Equations.Add(magMsg,0,-800)
	S.Equations.Add(angMsg,0,-700)
	S.Equations.Add("awr_load_pull_index=1",0,-600)

	vals = "stepped(1," + CStr(n+1) + ",1)"
	Set swpBlk = S.Elements.Add("SWPVAR",0,-2000)
	swpBlk.Parameters("ID").ValueAsString = "awr_load_pull_index"
	swpBlk.Parameters("VarName").ValueAsString = """awr_load_pull_index"""
	swpBlk.Parameters("Values").ValueAsString = vals

	'Debug.Print realMsg
	'Debug.Print imagMsg
	'Debug.Print magMsg
	'Debug.Print angMsg

End Function
Function removeStuffFromSchem(finalCleanup As Boolean) As Boolean

	Dim se As Element
	Dim ses As Elements
	Dim eq As Equation
	Dim eqs As Equations
	Dim searchStr As String
	Dim freqs() As Double
	Dim ex As String
	Dim newEq As String
	Dim origEq As String
	Dim l As String
	Dim r As String
	Dim i As Integer
	Dim j As Integer

	'Remove any variables that got added and reset sweep control variable to defaults
	If (S Is Nothing = False) Then
		searchStr = "awr_load_pull"
		Set eqs = S.Equations
		For Each eq In eqs
			If (InStr(eq.Expression,searchStr)) Then
				For i=1 To S.Equations.Count
					If (S.Equations(i).Expression = eq.Expression) Then
						S.Equations.Remove(i)
						Exit For
					End If
				Next i
			End If
		Next eq

		Set ses = S.Elements
		For Each se In ses
			If (se.Parameters.Exists("ID")) Then
				If(InStr(se.Parameters("ID").ValueAsString,searchStr)) Then
					S.Elements.Remove(se.Name)
					Exit For
				End If
			End If
		Next

		If (OrigMag <> "") And (SupportMode = False) Then
			MagParam.ValueAsString = OrigMag
			AngParam.ValueAsString = OrigAng
		End If

		If (finalCleanup) Then
			Debug.Print

			For i=0 To SwpValDict.Count - 1
				ex = SwpValDict.Items(i)
				getLeftAndRightEqSides(ex,l,r)
				setEquation(l,CDbl(r),newEq,origEq)
				If (finalCleanup) Then
					Debug.Print "Last Eqn: " + origEq
					Debug.Print "Orig Eqn: " + newEq
				End If
			Next i

			ReDim freqs(FreqPntDict.Count-1)
			For i=0 To FreqPntDict.Count-1
				freqs(i) = FreqPntDict.Items(i)
			Next i

			If (UBound(freqs) > 0) Then
				S.Frequencies.Clear
				S.Frequencies.AddMultiple(freqs)
			End If

			Set ses = S.Elements
			For Each se In ses
				If (SwpCtrlDict.Exists(se.Name)) Then
					se.Enabled = SwpCtrlDict(se.Name)
				End If
			Next se
		End If
	End If

End Function
Function getLeftAndRightEqSides(ex As String, ByRef l As String, ByRef r As String) As Boolean

	l = Split(ex,"=")(0)
	r = Split(ex,"=")(1)
	l = Trim(l)
	r = Trim(r)

End Function
Private Function dlgPointSelectFunc(DlgItem$, action%, suppValue&) As Boolean

	Dim df As DataFile
	Dim dfName As String
	Dim i As Integer
	Dim valErr As Boolean

	Select Case action%

	Case 1 'Dialog Open
		loadSavedUserOpts()

		If (DlgValue("readFile") = 0) Then
			DlgEnable("existingFile",False)
			DlgEnable("circleRadius",True)
			DlgEnable("centerMag",True)
			DlgEnable("centerAng",True)
			DlgEnable("numCircles",True)
			DlgEnable("pointsPerCircle",True)
			DlgEnable("lpMode",True)

			dlgFuncEnableForLPMode()
			valErr = dlgFuncCheckVals(DlgItem)

		Else
			DlgEnable("existingFile",True)
			DlgEnable("circleRadius",False)
			DlgEnable("centerMag",False)
			DlgEnable("centerAng",False)
			DlgEnable("numCircles",False)
			DlgEnable("pointsPerCircle",False)
			DlgEnable("lpMode",False)
			DlgEnable("lpWiz",False)

			If (DlgValue("existingFile") = -1) Then
				DlgValue("existingFile",0)
			End If
			ExistingFile = DlgText("existingfile")
		End If

		dlgFuncDrawGraph(DlgItem)

		If (TestMode) Then
			pressOK()
		End If

	Case 2 ' Value changing or button pressed
		If (DlgItem = "help") Then
			openHelp()
		End If

		If (DlgType(DlgItem) = "PushButton") And (DlgItem <> "help") Then
			valErr = dlgFuncCheckVals(DlgItem)
			If (valErr) Then
				clearGraph()
				dlgPointSelectFunc = True
			Else
				dlgFuncDrawGraph(DlgItem)
			End If
		End If

		If (DlgItem$ = "lpMode") Then
			dlgFuncEnableForLPMode()

			valErr = dlgFuncCheckVals(DlgItem)
			If (valErr) Then
				clearGraph()
				dlgPointSelectFunc = True
			Else
				dlgFuncDrawGraph(DlgItem)
			End If

		ElseIf (DlgItem$ = "lpWiz") Then
			getLoadPullWizardPoints(DlgValue("lpWiz"),True)

		ElseIf (DlgItem$ = "readFile") Then
			If (DlgValue(DlgItem) = 0) Then
				DlgEnable("existingFile",False)
				DlgEnable("circleRadius",True)
				DlgEnable("centerMag",True)
				DlgEnable("centerAng",True)
				DlgEnable("numCircles",True)
				DlgEnable("pointsPerCircle",True)
				DlgEnable("lpMode",True)

				dlgFuncEnableForLPMode()
				valErr = dlgFuncCheckVals(DlgItem)
			Else
				DlgEnable("existingFile",True)
				DlgEnable("circleRadius",False)
				DlgEnable("centerMag",False)
				DlgEnable("centerAng",False)
				DlgEnable("numCircles",False)
				DlgEnable("pointsPerCircle",False)
				DlgEnable("lpMode",False)
				DlgEnable("lpwiz",False)

				EditPoints = DlgValue("editPoints")

				If (DlgValue("existingFile") = -1) Then
					DlgValue("existingFile",0)
				End If

				ExistingFile = DlgText("existingfile")
				valErr = False
			End If

			If (valErr) Then
				clearGraph()
				dlgPointSelectFunc = True
			Else
				dlgFuncDrawGraph(DlgItem)
			End If

		ElseIf (DlgItem$ = "existingFile") Then
			If (DlgValue("readFile") = 1) Then
				EditPoints = DlgValue("editPoints")
				If (DlgValue("existingFile") = -1) Then
					DlgValue("existingFile",0)
				End If
				ExistingFile = DlgText("existingfile")
				getPointsFromLPFile(True)
			End If
		End If

		saveUserOpts(DlgItem$)
	Case 3 ' TextBox or ComboBox text changed
		If (DlgType(DlgItem$) = "TextBox") Then

			valErr = dlgFuncCheckVals(DlgItem$)
			If (valErr) Then
				clearGraph()
				dlgPointSelectFunc = True
			Else
				dlgFuncDrawGraph(DlgItem)
			End If
		End If

		saveUserOpts(DlgItem$)
	Case 4 ' Focus changed
	Case 5 ' Idle
	Case 6 ' Function key
	End Select

End Function
Function dlgFuncEnableForLPMode() As Boolean

	If (DlgValue("lpMode") = LP_MODE_FIXED_ANGLE) Or (DlgValue("lpMode") = LP_MODE_WIZARD) Or (DlgValue("lpMode") = LP_MODE_SQUARE) Then
		DlgEnable("pointsPerCircle",False)
	Else
		DlgEnable("pointsPerCircle",True)
	End If

	If (DlgValue("lpMode") = LP_MODE_WIZARD) Then
		DlgEnable("numCircles",False)
		DlgEnable("lpWiz",True)
	Else
		DlgEnable("numCircles",True)
		DlgEnable("lpwiz",False)
	End If

	If (DlgValue("lpMode") = LP_MODE_SQUARE) Then
		DlgText("text4","Number of rows / cols")
	Else
		DlgText("text4","Number of circles")
	End If

End Function

Function dlgFuncCheckVals(DlgItem As String) As Boolean

	Dim hasErr As Boolean
	Dim msg As String

	dlgFuncCheckVals = False
	hasErr = False

	'If (DlgText("circleRadius") = "") Then
	'	msg = "Radius must not be empty"
	'	hasErr = True
	'ElseIf (DlgText("centerMag") = "") Then
	'	msg = "Center Magnitude must not be empty"
	'	hasErr = True
	'ElseIf (DlgText("centerAng") = "") Then
	'	msg = "Center Angle must not be empty"
	'	hasErr = True
	'ElseIf (DlgText("numCircles") = "") Then
	'	msg = "Number of Circles must not be empty"
	'	hasErr = True
	'ElseIf (DlgText("pointsPerCircle") = "") Then
	'	msg = "Points Per Circle must not be empty"
	'	hasErr = True
	'ElseIf (DlgText("lpMode") = "") Then
	'	msg = "Mode must not be empty"
	'	hasErr = True
	'End If
	'If (hasErr) Then
	'	giveErrMsg(msg)
	'	dlgFuncCheckVals = True
	'	Exit Function
	'End If

	If (IsNumeric(getRegionalString(DlgText("circleRadius"))) = False) Then
		msg = "Radius must be a number"
		hasErr = True
	ElseIf (IsNumeric(getRegionalString(DlgText("centerMag"))) = False) Then
		msg = "Center Magnitude must be a number"
		hasErr = True
	ElseIf (IsNumeric(getRegionalString(DlgText("centerAng"))) = False) Then
		msg = "Center Angle must be a number"
		hasErr = True
	ElseIf (IsNumeric(getRegionalString(DlgText("numCircles"))) = False) Then
		msg = "Number of Circles must be a number"
		hasErr = True
	ElseIf (IsNumeric(getRegionalString(DlgText("pointsPerCircle"))) = False) Then
		msg = "Points Per Circle must be a number"
		hasErr = True
	End If
	If (hasErr) Then
		giveErrMsg(msg)
		dlgFuncCheckVals = True
		Exit Function
	End If

	Rad = CDbl(getRegionalString(DlgText("circleRadius")))
	MC = CDbl(getRegionalString(DlgText("centerMag")))
	AC = CDbl(getRegionalString(DlgText("centerAng")))
	NMC = CDbl(getRegionalString(DlgText("numCircles")))
	PPC = CDbl(getRegionalString(DlgText("pointsPerCircle")))
	MD = CDbl(getRegionalString(DlgValue("lpMode")))

	DlgText("circleRadius",getAllowedSeparator(DlgText("circleRadius")))
	DlgText("centerMag",getAllowedSeparator(DlgText("centerMag")))
	DlgText("centerAng",getAllowedSeparator(DlgText("centerAng")))
	DlgText("numCircles",getAllowedSeparator(DlgText("numCircles")))
	DlgText("pointsPerCircle",getAllowedSeparator(DlgText("pointsPerCircle")))
	DlgText("lpMode",getAllowedSeparator(DlgText("lpMode")))

	dlgFuncCheckVals = checkDlgVals(False)

	'msg = "Load Pull fields must use ""."" for separator, not "","""
	'If (InStr(DlgText("circleRadius"),",")) Then
		'hasErr = True
	'ElseIf (InStr(DlgText("centerMag"),",")) Then
		'hasErr = True
	'ElseIf (InStr(DlgText("centerAng"),",")) Then
		'hasErr = True
	'ElseIf (InStr(DlgText("numCircles"),",")) Then
		'hasErr = True
	'ElseIf (InStr(DlgText("pointsPerCircle"),",")) Then
		'hasErr = True
	'ElseIf (InStr(DlgText("lpMode"),",")) Then
		'hasErr = True
	'End If
	'If (hasErr) Then
		'giveErrMsg(msg)
		'dlgFuncCheckVals = True
		'Exit Function
	'End If

	'If (dlgFuncCheckVals) Then
	'	DlgText("circleRadius",CStr(Rad))
	'	DlgText("centerMag",CStr(MC))
	'	DlgText("centerAng",CStr(AC))
	'	DlgText("numCircles",CStr(NMC))
	'	DlgText("pointsPerCircle",CStr(PPC))
	'End If

End Function
Function dlgFuncDrawGraph(DlgItem As String) As Boolean

	ExistingFile = DlgText("existingfile")

	If (DlgValue("readFile") = 0) Then
		If (DlgValue("lpMode") = LP_MODE_WIZARD) Then
			getLoadPullWizardPoints(DlgValue("lpWiz"),True)
		Else
			getCalculatedPoints(True)
		End If
	Else
		getPointsFromLPFile(True)
	End If

End Function
Private Function dlgLoadPullFunc(DlgItem$, action%, suppValue&) As Boolean

	Dim hasHBTuner As Boolean
	Dim i As Integer
	Dim n As Integer
	Dim schem As String
	Dim tuner As String
	Dim toks() As Integer

	hasHBTuner = False

	Select Case action%

	Case 1 'Dialog Open
		loadSavedUserOpts()

		dlgFuncChooseTuner()

		'Set this here because dlgFuncChooseTuner() changed the saved user opts
		If (DlgListBoxArray("tuner")-1 >= CInt(PropDict("tuner"))) Then
			DlgValue("tuner",PropDict("tuner"))
		Else
			DlgValue("tuner",0)
		End If

		If (TestMode) Then
			pressOK()
		End If

	Case 2 ' Value changing or button pressed
		If (DlgItem = "help") Then
			openHelp()
		End If

		If (DlgItem = "schem") Then
			dlgFuncChooseTuner()
			DlgValue("tuner",0)
			dlgLoadPullFunc = True
		End If

		If (DlgItem = "selectAll") Then
			n = DlgListBoxArray("meas") - 1
			ReDim toks(n)
			For i = 0 To n
				toks(i) = i
			Next
			DlgValue("meas",toks)
			DlgFocus("meas")
			dlgLoadPullFunc = True
		End If

		If (DlgItem = "useSchName") Then
			DlgText("fName",DlgText("schem") + " Data")
			DlgText("gName",DlgText("schem") + " Results")
			dlgLoadPullFunc = True
		End If

		saveUserOpts(DlgItem)
	Case 3 ' TextBox or ComboBox text changed
	Case 4 ' Focus changed
	Case 5 ' Idle
	Case 6 ' Function key
	End Select

End Function
Private Function dlgConstPoutFunc(DlgItem$, action%, suppValue&) As Boolean

	Select Case action%

	Case 1 'Dialog Open
		loadSavedUserOpts()

		If (TestMode) Then
			pressOK()
		End If

	Case 2 ' Value changing or button pressed
		saveUserOpts(DlgItem$)

	Case 3 ' TextBox or ComboBox text changed
		saveUserOpts(DlgItem$)

	Case 4 ' Focus changed
	Case 5 ' Idle
	Case 6 ' Function key
	End Select

End Function
Function dlgFuncChooseTuner() As Boolean

	Dim schemName As String
	Dim meas As String
	Dim tuner As String
	Dim sToks() As String
	Dim tToks() As String
	Dim mToks() As String
	Dim nMeas As Integer
	Dim nTune As Integer
	Dim nOldMeas As Integer
	Dim hasHBTuner As Boolean
	Dim stateSelect() As Integer
	Dim defaultSelect As Boolean
	Dim i As Long

	hasHBTuner = False

	schemName = DlgText("schem")
	meas = MeasDict(schemName)
	sToks = Split(meas,StrDelim)
	nMeas = UBound(sToks)
	ReDim TunerMeas(nMeas)
	mToks = Split(PropDict("meas"),RegionalDelimiter)
	nOldMeas = UBound(mToks)
	If (nOldMeas <= nMeas) And (schemName = PropDict("schemName")) Then
		defaultSelect = False
		ReDim stateSelect(nOldMeas)
		For i=0 To nOldMeas
				stateSelect(i) = CInt(mToks(i))
		Next i
	Else
		defaultSelect = True
		ReDim stateSelect(nMeas)
	End If
	For i=0 To nMeas
		If (defaultSelect) Then
			stateSelect(i) = 0
		End If
		TunerMeas(i) = sToks(i)
	Next i
	DlgListBoxArray("meas",TunerMeas)
	DlgValue("meas",stateSelect)

	tuner = TunerDict(schemName)
	tToks = Split(tuner,StrDelim)
	nTune = UBound(tToks)
	ReDim Tuners(nTune)
	For i=0 To nTune
		Tuners(i) = tToks(i)
		If (InStr(Tuners(i),"HB")) Then
			hasHBTuner = True
		End If
	Next i
	DlgListBoxArray("tuner",Tuners)
	If (hasHBTuner) Then
		DlgEnable("harmonic",True)
	Else
		DlgEnable("harmonic",False)
	End If

End Function
Function pressOK() As Boolean

	DlgEnd(-1)

End Function
Function loadSavedUserOpts()

	Dim fieldName As String
	Dim i As Long
	Dim l As String
	Dim lines() As String
	Dim r As String
	Dim sdf As DataFile
	Dim toks() As String

	'Make sure we don't parse the settings file more than once
	If (PropDict.Count = 0) Then
		initOptions() 'init and then override, so any missing options get defaulted
		If (Project.DataFiles.Exists(PropDFName)) Then
			Set sdf = Project.DataFiles(PropDFName)
			lines = Split(sdf.DataAsText, vbLf)
			For i = 0 To UBound(lines)
				toks = Split(lines(i), "=")
				If (UBound(toks) = 1) Then
					l = Trim(toks(0))
					r = Trim(toks(1))
					'In 10.0 "mode" became a built in property and turned to "Mode" so needed to be changed.
					If (l = "mode") Then
						l = "lpMode"
					End If
					'Debug.Print l + " = " + r + " (" + fixDelimiter(r) + ")"
					If (l <> USER_MEAS_NAMES) Then
						r = getRegionalString(r)
					End If
					PropDict(l) = r
				End If
			Next i
		End If
	End If

	For i = 0 To DlgCount - 1
		fieldName = DlgName(i)
		If (PropDict.Exists(fieldName)) Then
			Select Case DlgType(i)
			Case "TextBox"
				DlgText i, PropDict(fieldName)
			Case "CheckBox", "ComboBox", "DropListBox", "ListBox", "OptionGroup"
				DlgValue(fieldName,PropDict(fieldName))
			End Select
		End If
	Next i

End Function
Function saveUserOpts(DlgItem As String)

	Dim sdf As DataFile
	Dim optNames()
	Dim fieldName As String
	Dim i As Long
	Dim j As Long
	Dim sText As String

	If (DlgItem <> "") Then
		If ((DlgType(DlgItem) = "OKButton") Or (DlgType(DlgItem) = "PushButton")) Then
			For i = 0 To DlgCount - 1
				fieldName = DlgName(i)
				Select Case DlgType(i)
				Case "TextBox"
					PropDict(fieldName) = getAllowedSeparator(DlgText(i))
				Case "CheckBox", "ComboBox", "DropListBox", "ListBox", "OptionGroup"
					If (fieldName = "schem") Then
						PropDict("schemName") = DlgText(i)
					End If
					PropDict(fieldName) = DlgValue(i)
				Case "MultiListBox"
					sText = ""
					For j=0 To UBound(DlgValue(i))
						sText = sText + CStr(DlgValue(i)(j))
						If (j < UBound(DlgValue(i))) Then
							sText = sText + ","
						End If
					Next j
					PropDict(fieldName) = sText
				End Select
			Next i
		End If
	End If

	If (Project.DataFiles.Exists(PropDFName)) Then
		Set sdf = Project.DataFiles(PropDFName)
	Else
		Set sdf = Project.DataFiles.AddNew(PropDFName, mwDFT_TXT)
	End If

	For i = sdf.Windows.Count To 1 Step -1
		sdf.Windows(i).Close
	Next i

	If (PropDict.Count > 0) Then
		optNames = PropDict.Keys()
		sText = optNames(0) & "=" & PropDict(optNames(0)) & vbLf
		For i = 1 To UBound(optNames)
			sText = sText & optNames(i) & "=" & PropDict(optNames(i)) & vbLf
		Next i
		sdf.DataAsText = sText
	End If

	copyUserOptsToConfigFile()

End Function
Function copyUserOptsToConfigFile()

	Dim dfName As String

	If (Project.DataFiles.Exists(PropDFName)) And (S Is Nothing = False) Then
		dfName = PropDFName + "_" + Replace(S.Name," ","_")
		If (Project.DataFiles.Exists(dfName)) Then
			Project.DataFiles.Remove(dfName)
		End If
		Project.DataFiles.Copy(PropDFName,dfName)
	End If

End Function
Function initOptions()

	'Point select
	PropDict("circleRadius") = getAllowedSeparator(CStr(DefRad))
	PropDict("centerMag") = getAllowedSeparator(CStr(DefMC))
	PropDict("centerAng") = getAllowedSeparator(CStr(DefAC))
	PropDict("numCircles") = getAllowedSeparator(CStr(DefNMC))
	PropDict("pointsPerCircle") = getAllowedSeparator(CStr(DefPPC))
	PropDict("lpMode") = LP_MODE_WIZARD

	'Load Pull
	PropDict("tuner") = 0
	PropDict("fastMode") = 0
	PropDict("fName") = LoadPullDFName
	PropDict("gName") = LoadPullGName
	PropDict("overwriteFiles") = 0
	PropDict("performMultiple") = 0
	PropDict("plotContours") = 1
	PropDict("plotContoursMax") = 1
	PropDict("plotConverged") = 1
	PropDict("plotFailed") = 1
	PropDict("meas") = 0
	PropDict("schemName") = "None"
	PropDict("useIterative") = 1

	'ConstPout
	PropDict("cPoutD") = 0.1
	PropDict("cPoutMeas") = 0

End Function
Function closeGraphWindows() As Boolean

	Dim i As Integer

	If (G.Windows.Count > 0) Then
		For i=1 To G.Windows.Count
			G.Windows(i).Close()
		Next i
	End If

End Function
Function stringReplace (origString As String, searchChars As String, newChar As String) As String

	Dim i As Integer
	Dim data As String
	Dim char As String
	Dim temp As String
	Dim msg As String

	data = origString
	For i = 1 To Len(searchChars)
		char=Mid(searchChars,i,1)

		If (InStr(origString,char) <> 0) Then
			data = Replace(data, char, newChar)
		End If
	Next i

	'Make sure the name doesn't begin with a special character
	While (Left(data,1) = newChar)
		data = Right(data,Len(data)-1)
	Wend

	stringReplace=data

End Function
Function fixUnits(data As Double, meas As Measurement) As Double

	Dim newData As Double
	Dim unitType As Double
	Dim mult As Double

	unitType = meas.UnitType(2)

	If unitType = 13 Then
		If Project.Units(unitType).UnitString = "dBm" Then
			mult = 30
		Else
			mult = 0
		End If

		newData = data + mult
	Else
		mult = Project.Units(unitType).MultValue
		newData = data/mult
	End If

	fixUnits = newData

End Function
Function atan2(ByVal y As Double, ByVal x As Double) As Double

	Dim theta As Double

	If (Abs(x) < 0.0000001) Then
		If (Abs(y) < 0.0000001) Then
		  theta = 0#
		ElseIf (y > 0#) Then
		  theta = PI/2
		Else
		  theta = -PI/2
		End If
	Else
		theta = Atn(y / x)
		If (x < 0) Then
		  If (y >= 0#) Then
		    theta = PI + theta
		  Else
		    theta = theta - PI
		  End If
		End If
	End If

	If theta < 0 Then
		theta = theta+2*PI
	End If

	atan2 = theta*180/PI

End Function
Function atan2Ex(ByVal y As Double, ByVal x As Double) As Double

  Dim theta As Double

  If (Abs(x) < 0.0000001) Then
    If (Abs(y) < 0.0000001) Then
      theta = 0#
    ElseIf (y > 0#) Then
      theta = PI/2
    Else
      theta = -PI/2
    End If
  Else
    theta = Atn(y / x)

    If (x < 0) Then
      If (y >= 0#) Then
        theta = PI + theta
      Else
        theta = theta - PI
      End If
    End If
  End If

  If theta < 0 Then
	theta = theta+2*PI
  End If

  atan2Ex = theta*180/PI

End Function
Function getMagFromRI(re As Double, im As Double) As Double

	getMagFromRI = Sqr(re*re + im*im)

End Function
Function getAngFromRI(re As Double, im As Double) As Double

	getAngFromRI = atan2(im,re)

End Function
Function degToRad(ang As Double) As Double

	degToRad = ang*PI/180

End Function
Function getLoadPullWizardPoints(mode As Integer, writeGraph As Boolean) As Boolean

	Dim mags() As Double
	Dim angs() As Double
	Dim i As Integer
	Dim n As Integer
	Dim re As Double
	Dim im As Double
	Dim xx As Double
	Dim yy As Double
	Dim deltaxx As Double
	Dim deltayy As Double
	Dim mag As Double
	Dim ang As Double
	Dim nPts As Long
	Dim lppt As pt

	Select Case mode
	Case 0
		nPts = 60
		ReDim mags(nPts)
		ReDim angs(nPts)
		mags(0)=	0.950000
		angs(0)=	0.000000
		mags(1)=	0.950000
		angs(1)=	15.000000
		mags(2)=	0.950000
		angs(2)=	30.000000
		mags(3)=	0.950000
		angs(3)=	45.000000
		mags(4)=	0.950000
		angs(4)=	60.000000
		mags(5)=	0.950000
		angs(5)=	75.000000
		mags(6)=	0.950000
		angs(6)=	90.000000
		mags(7)=	0.950000
		angs(7)=	105.000000
		mags(8)=	0.950000
		angs(8)=	120.000000
		mags(9)=	0.950000
		angs(9)=	135.000000
		mags(10)=	0.950000
		angs(10)=	150.000000
		mags(11)=	0.950000
		angs(11)=	165.000000
		mags(12)=	0.950000
		angs(12)=	180.000000
		mags(13)=	0.950000
		angs(13)=	195.000000
		mags(14)=	0.950000
		angs(14)=	210.000000
		mags(15)=	0.950000
		angs(15)=	225.000000
		mags(16)=	0.950000
		angs(16)=	240.000000
		mags(17)=	0.950000
		angs(17)=	255.000000
		mags(18)=	0.950000
		angs(18)=	270.000000
		mags(19)=	0.950000
		angs(19)=	285.000000
		mags(20)=	0.950000
		angs(20)=	300.000000
		mags(21)=	0.950000
		angs(21)=	315.000000
		mags(22)=	0.950000
		angs(22)=	330.000000
		mags(23)=	0.950000
		angs(23)=	345.000000
		mags(24)=	0.712500
		angs(24)=	0.000000
		mags(25)=	0.712500
		angs(25)=	20.000000
		mags(26)=	0.712500
		angs(26)=	40.000000
		mags(27)=	0.712500
		angs(27)=	60.000000
		mags(28)=	0.712500
		angs(28)=	80.000000
		mags(29)=	0.712500
		angs(29)=	100.000000
		mags(30)=	0.712500
		angs(30)=	120.000000
		mags(31)=	0.712500
		angs(31)=	140.000000
		mags(32)=	0.712500
		angs(32)=	160.000000
		mags(33)=	0.712500
		angs(33)=	180.000000
		mags(34)=	0.712500
		angs(34)=	200.000000
		mags(35)=	0.712500
		angs(35)=	220.000000
		mags(36)=	0.712500
		angs(36)=	240.000000
		mags(37)=	0.712500
		angs(37)=	260.000000
		mags(38)=	0.712500
		angs(38)=	280.000000
		mags(39)=	0.712500
		angs(39)=	300.000000
		mags(40)=	0.712500
		angs(40)=	320.000000
		mags(41)=	0.712500
		angs(41)=	340.000000
		mags(42)=	0.475000
		angs(42)=	0.000000
		mags(43)=	0.475000
		angs(43)=	30.000000
		mags(44)=	0.475000
		angs(44)=	60.000000
		mags(45)=	0.475000
		angs(45)=	90.000000
		mags(46)=	0.475000
		angs(46)=	120.000000
		mags(47)=	0.475000
		angs(47)=	150.000000
		mags(48)=	0.475000
		angs(48)=	180.000000
		mags(49)=	0.475000
		angs(49)=	210.000000
		mags(50)=	0.475000
		angs(50)=	240.000000
		mags(51)=	0.475000
		angs(51)=	270.000000
		mags(52)=	0.475000
		angs(52)=	300.000000
		mags(53)=	0.475000
		angs(53)=	330.000000
		mags(54)=	0.237500
		angs(54)=	0.000000
		mags(55)=	0.237500
		angs(55)=	60.000000
		mags(56)=	0.237500
		angs(56)=	120.000000
		mags(57)=	0.237500
		angs(57)=	180.000000
		mags(58)=	0.237500
		angs(58)=	240.000000
		mags(59)=	0.237500
		angs(59)=	300.000000
		mags(60)=	0.000000
		angs(60)=	0.000000

	Case 1
		nPts = 126
		ReDim mags(nPts)
		ReDim angs(nPts)
		mags(0)=	0.950000
		angs(0)=	0.000000
		mags(1)=	0.950000
		angs(1)=	10.000000
		mags(2)=	0.950000
		angs(2)=	20.000000
		mags(3)=	0.950000
		angs(3)=	30.000000
		mags(4)=	0.950000
		angs(4)=	40.000000
		mags(5)=	0.950000
		angs(5)=	50.000000
		mags(6)=	0.950000
		angs(6)=	60.000000
		mags(7)=	0.950000
		angs(7)=	70.000000
		mags(8)=	0.950000
		angs(8)=	80.000000
		mags(9)=	0.950000
		angs(9)=	90.000000
		mags(10)=	0.950000
		angs(10)=	100.000000
		mags(11)=	0.950000
		angs(11)=	110.000000
		mags(12)=	0.950000
		angs(12)=	120.000000
		mags(13)=	0.950000
		angs(13)=	130.000000
		mags(14)=	0.950000
		angs(14)=	140.000000
		mags(15)=	0.950000
		angs(15)=	150.000000
		mags(16)=	0.950000
		angs(16)=	160.000000
		mags(17)=	0.950000
		angs(17)=	170.000000
		mags(18)=	0.950000
		angs(18)=	180.000000
		mags(19)=	0.950000
		angs(19)=	190.000000
		mags(20)=	0.950000
		angs(20)=	200.000000
		mags(21)=	0.950000
		angs(21)=	210.000000
		mags(22)=	0.950000
		angs(22)=	220.000000
		mags(23)=	0.950000
		angs(23)=	230.000000
		mags(24)=	0.950000
		angs(24)=	240.000000
		mags(25)=	0.950000
		angs(25)=	250.000000
		mags(26)=	0.950000
		angs(26)=	260.000000
		mags(27)=	0.950000
		angs(27)=	270.000000
		mags(28)=	0.950000
		angs(28)=	280.000000
		mags(29)=	0.950000
		angs(29)=	290.000000
		mags(30)=	0.950000
		angs(30)=	300.000000
		mags(31)=	0.950000
		angs(31)=	310.000000
		mags(32)=	0.950000
		angs(32)=	320.000000
		mags(33)=	0.950000
		angs(33)=	330.000000
		mags(34)=	0.950000
		angs(34)=	340.000000
		mags(35)=	0.950000
		angs(35)=	350.000000
		mags(36)=	0.791667
		angs(36)=	0.000000
		mags(37)=	0.791667
		angs(37)=	12.000000
		mags(38)=	0.791667
		angs(38)=	24.000000
		mags(39)=	0.791667
		angs(39)=	36.000000
		mags(40)=	0.791667
		angs(40)=	48.000000
		mags(41)=	0.791667
		angs(41)=	60.000000
		mags(42)=	0.791667
		angs(42)=	72.000000
		mags(43)=	0.791667
		angs(43)=	84.000000
		mags(44)=	0.791667
		angs(44)=	96.000000
		mags(45)=	0.791667
		angs(45)=	108.000000
		mags(46)=	0.791667
		angs(46)=	120.000000
		mags(47)=	0.791667
		angs(47)=	132.000000
		mags(48)=	0.791667
		angs(48)=	144.000000
		mags(49)=	0.791667
		angs(49)=	156.000000
		mags(50)=	0.791667
		angs(50)=	168.000000
		mags(51)=	0.791667
		angs(51)=	180.000000
		mags(52)=	0.791667
		angs(52)=	192.000000
		mags(53)=	0.791667
		angs(53)=	204.000000
		mags(54)=	0.791667
		angs(54)=	216.000000
		mags(55)=	0.791667
		angs(55)=	228.000000
		mags(56)=	0.791667
		angs(56)=	240.000000
		mags(57)=	0.791667
		angs(57)=	252.000000
		mags(58)=	0.791667
		angs(58)=	264.000000
		mags(59)=	0.791667
		angs(59)=	276.000000
		mags(60)=	0.791667
		angs(60)=	288.000000
		mags(61)=	0.791667
		angs(61)=	300.000000
		mags(62)=	0.791667
		angs(62)=	312.000000
		mags(63)=	0.791667
		angs(63)=	324.000000
		mags(64)=	0.791667
		angs(64)=	336.000000
		mags(65)=	0.791667
		angs(65)=	348.000000
		mags(66)=	0.633333
		angs(66)=	0.000000
		mags(67)=	0.633333
		angs(67)=	15.000000
		mags(68)=	0.633333
		angs(68)=	30.000000
		mags(69)=	0.633333
		angs(69)=	45.000000
		mags(70)=	0.633333
		angs(70)=	60.000000
		mags(71)=	0.633333
		angs(71)=	75.000000
		mags(72)=	0.633333
		angs(72)=	90.000000
		mags(73)=	0.633333
		angs(73)=	105.000000
		mags(74)=	0.633333
		angs(74)=	120.000000
		mags(75)=	0.633333
		angs(75)=	135.000000
		mags(76)=	0.633333
		angs(76)=	150.000000
		mags(77)=	0.633333
		angs(77)=	165.000000
		mags(78)=	0.633333
		angs(78)=	180.000000
		mags(79)=	0.633333
		angs(79)=	195.000000
		mags(80)=	0.633333
		angs(80)=	210.000000
		mags(81)=	0.633333
		angs(81)=	225.000000
		mags(82)=	0.633333
		angs(82)=	240.000000
		mags(83)=	0.633333
		angs(83)=	255.000000
		mags(84)=	0.633333
		angs(84)=	270.000000
		mags(85)=	0.633333
		angs(85)=	285.000000
		mags(86)=	0.633333
		angs(86)=	300.000000
		mags(87)=	0.633333
		angs(87)=	315.000000
		mags(88)=	0.633333
		angs(88)=	330.000000
		mags(89)=	0.633333
		angs(89)=	345.000000
		mags(90)=	0.475000
		angs(90)=	0.000000
		mags(91)=	0.475000
		angs(91)=	20.000000
		mags(92)=	0.475000
		angs(92)=	40.000000
		mags(93)=	0.475000
		angs(93)=	60.000000
		mags(94)=	0.475000
		angs(94)=	80.000000
		mags(95)=	0.475000
		angs(95)=	100.000000
		mags(96)=	0.475000
		angs(96)=	120.000000
		mags(97)=	0.475000
		angs(97)=	140.000000
		mags(98)=	0.475000
		angs(98)=	160.000000
		mags(99)=	0.475000
		angs(99)=	180.000000
		mags(100)=	0.475000
		angs(100)=	200.000000
		mags(101)=	0.475000
		angs(101)=	220.000000
		mags(102)=	0.475000
		angs(102)=	240.000000
		mags(103)=	0.475000
		angs(103)=	260.000000
		mags(104)=	0.475000
		angs(104)=	280.000000
		mags(105)=	0.475000
		angs(105)=	300.000000
		mags(106)=	0.475000
		angs(106)=	320.000000
		mags(107)=	0.475000
		angs(107)=	340.000000
		mags(108)=	0.316667
		angs(108)=	0.000000
		mags(109)=	0.316667
		angs(109)=	30.000000
		mags(110)=	0.316667
		angs(110)=	60.000000
		mags(111)=	0.316667
		angs(111)=	90.000000
		mags(112)=	0.316667
		angs(112)=	120.000000
		mags(113)=	0.316667
		angs(113)=	150.000000
		mags(114)=	0.316667
		angs(114)=	180.000000
		mags(115)=	0.316667
		angs(115)=	210.000000
		mags(116)=	0.316667
		angs(116)=	240.000000
		mags(117)=	0.316667
		angs(117)=	270.000000
		mags(118)=	0.316667
		angs(118)=	300.000000
		mags(119)=	0.316667
		angs(119)=	330.000000
		mags(120)=	0.158333
		angs(120)=	0.000000
		mags(121)=	0.158333
		angs(121)=	60.000000
		mags(122)=	0.158333
		angs(122)=	120.000000
		mags(123)=	0.158333
		angs(123)=	180.000000
		mags(124)=	0.158333
		angs(124)=	240.000000
		mags(125)=	0.158333
		angs(125)=	300.000000
		mags(126)=	0.000000
		angs(126)=	0.000000

		Case 2
		nPts = 216
		ReDim mags(nPts)
		ReDim angs(nPts)
		mags(0)=	0.950000
		angs(0)=	0.000000
		mags(1)=	0.950000
		angs(1)=	7.500000
		mags(2)=	0.950000
		angs(2)=	15.000000
		mags(3)=	0.950000
		angs(3)=	22.500000
		mags(4)=	0.950000
		angs(4)=	30.000000
		mags(5)=	0.950000
		angs(5)=	37.500000
		mags(6)=	0.950000
		angs(6)=	45.000000
		mags(7)=	0.950000
		angs(7)=	52.500000
		mags(8)=	0.950000
		angs(8)=	60.000000
		mags(9)=	0.950000
		angs(9)=	67.500000
		mags(10)=	0.950000
		angs(10)=	75.000000
		mags(11)=	0.950000
		angs(11)=	82.500000
		mags(12)=	0.950000
		angs(12)=	90.000000
		mags(13)=	0.950000
		angs(13)=	97.500000
		mags(14)=	0.950000
		angs(14)=	105.000000
		mags(15)=	0.950000
		angs(15)=	112.500000
		mags(16)=	0.950000
		angs(16)=	120.000000
		mags(17)=	0.950000
		angs(17)=	127.500000
		mags(18)=	0.950000
		angs(18)=	135.000000
		mags(19)=	0.950000
		angs(19)=	142.500000
		mags(20)=	0.950000
		angs(20)=	150.000000
		mags(21)=	0.950000
		angs(21)=	157.500000
		mags(22)=	0.950000
		angs(22)=	165.000000
		mags(23)=	0.950000
		angs(23)=	172.500000
		mags(24)=	0.950000
		angs(24)=	180.000000
		mags(25)=	0.950000
		angs(25)=	187.500000
		mags(26)=	0.950000
		angs(26)=	195.000000
		mags(27)=	0.950000
		angs(27)=	202.500000
		mags(28)=	0.950000
		angs(28)=	210.000000
		mags(29)=	0.950000
		angs(29)=	217.500000
		mags(30)=	0.950000
		angs(30)=	225.000000
		mags(31)=	0.950000
		angs(31)=	232.500000
		mags(32)=	0.950000
		angs(32)=	240.000000
		mags(33)=	0.950000
		angs(33)=	247.500000
		mags(34)=	0.950000
		angs(34)=	255.000000
		mags(35)=	0.950000
		angs(35)=	262.500000
		mags(36)=	0.950000
		angs(36)=	270.000000
		mags(37)=	0.950000
		angs(37)=	277.500000
		mags(38)=	0.950000
		angs(38)=	285.000000
		mags(39)=	0.950000
		angs(39)=	292.500000
		mags(40)=	0.950000
		angs(40)=	300.000000
		mags(41)=	0.950000
		angs(41)=	307.500000
		mags(42)=	0.950000
		angs(42)=	315.000000
		mags(43)=	0.950000
		angs(43)=	322.500000
		mags(44)=	0.950000
		angs(44)=	330.000000
		mags(45)=	0.950000
		angs(45)=	337.500000
		mags(46)=	0.950000
		angs(46)=	345.000000
		mags(47)=	0.950000
		angs(47)=	352.500000
		mags(48)=	0.831250
		angs(48)=	0.000000
		mags(49)=	0.831250
		angs(49)=	8.571429
		mags(50)=	0.831250
		angs(50)=	17.142857
		mags(51)=	0.831250
		angs(51)=	25.714286
		mags(52)=	0.831250
		angs(52)=	34.285714
		mags(53)=	0.831250
		angs(53)=	42.857143
		mags(54)=	0.831250
		angs(54)=	51.428571
		mags(55)=	0.831250
		angs(55)=	60.000000
		mags(56)=	0.831250
		angs(56)=	68.571429
		mags(57)=	0.831250
		angs(57)=	77.142857
		mags(58)=	0.831250
		angs(58)=	85.714286
		mags(59)=	0.831250
		angs(59)=	94.285714
		mags(60)=	0.831250
		angs(60)=	102.857143
		mags(61)=	0.831250
		angs(61)=	111.428571
		mags(62)=	0.831250
		angs(62)=	120.000000
		mags(63)=	0.831250
		angs(63)=	128.571429
		mags(64)=	0.831250
		angs(64)=	137.142857
		mags(65)=	0.831250
		angs(65)=	145.714286
		mags(66)=	0.831250
		angs(66)=	154.285714
		mags(67)=	0.831250
		angs(67)=	162.857143
		mags(68)=	0.831250
		angs(68)=	171.428571
		mags(69)=	0.831250
		angs(69)=	180.000000
		mags(70)=	0.831250
		angs(70)=	188.571429
		mags(71)=	0.831250
		angs(71)=	197.142857
		mags(72)=	0.831250
		angs(72)=	205.714286
		mags(73)=	0.831250
		angs(73)=	214.285714
		mags(74)=	0.831250
		angs(74)=	222.857143
		mags(75)=	0.831250
		angs(75)=	231.428571
		mags(76)=	0.831250
		angs(76)=	240.000000
		mags(77)=	0.831250
		angs(77)=	248.571429
		mags(78)=	0.831250
		angs(78)=	257.142857
		mags(79)=	0.831250
		angs(79)=	265.714286
		mags(80)=	0.831250
		angs(80)=	274.285714
		mags(81)=	0.831250
		angs(81)=	282.857143
		mags(82)=	0.831250
		angs(82)=	291.428571
		mags(83)=	0.831250
		angs(83)=	300.000000
		mags(84)=	0.831250
		angs(84)=	308.571429
		mags(85)=	0.831250
		angs(85)=	317.142857
		mags(86)=	0.831250
		angs(86)=	325.714286
		mags(87)=	0.831250
		angs(87)=	334.285714
		mags(88)=	0.831250
		angs(88)=	342.857143
		mags(89)=	0.831250
		angs(89)=	351.428571
		mags(90)=	0.712500
		angs(90)=	0.000000
		mags(91)=	0.712500
		angs(91)=	10.000000
		mags(92)=	0.712500
		angs(92)=	20.000000
		mags(93)=	0.712500
		angs(93)=	30.000000
		mags(94)=	0.712500
		angs(94)=	40.000000
		mags(95)=	0.712500
		angs(95)=	50.000000
		mags(96)=	0.712500
		angs(96)=	60.000000
		mags(97)=	0.712500
		angs(97)=	70.000000
		mags(98)=	0.712500
		angs(98)=	80.000000
		mags(99)=	0.712500
		angs(99)=	90.000000
		mags(100)=	0.712500
		angs(100)=	100.000000
		mags(101)=	0.712500
		angs(101)=	110.000000
		mags(102)=	0.712500
		angs(102)=	120.000000
		mags(103)=	0.712500
		angs(103)=	130.000000
		mags(104)=	0.712500
		angs(104)=	140.000000
		mags(105)=	0.712500
		angs(105)=	150.000000
		mags(106)=	0.712500
		angs(106)=	160.000000
		mags(107)=	0.712500
		angs(107)=	170.000000
		mags(108)=	0.712500
		angs(108)=	180.000000
		mags(109)=	0.712500
		angs(109)=	190.000000
		mags(110)=	0.712500
		angs(110)=	200.000000
		mags(111)=	0.712500
		angs(111)=	210.000000
		mags(112)=	0.712500
		angs(112)=	220.000000
		mags(113)=	0.712500
		angs(113)=	230.000000
		mags(114)=	0.712500
		angs(114)=	240.000000
		mags(115)=	0.712500
		angs(115)=	250.000000
		mags(116)=	0.712500
		angs(116)=	260.000000
		mags(117)=	0.712500
		angs(117)=	270.000000
		mags(118)=	0.712500
		angs(118)=	280.000000
		mags(119)=	0.712500
		angs(119)=	290.000000
		mags(120)=	0.712500
		angs(120)=	300.000000
		mags(121)=	0.712500
		angs(121)=	310.000000
		mags(122)=	0.712500
		angs(122)=	320.000000
		mags(123)=	0.712500
		angs(123)=	330.000000
		mags(124)=	0.712500
		angs(124)=	340.000000
		mags(125)=	0.712500
		angs(125)=	350.000000
		mags(126)=	0.593750
		angs(126)=	0.000000
		mags(127)=	0.593750
		angs(127)=	12.000000
		mags(128)=	0.593750
		angs(128)=	24.000000
		mags(129)=	0.593750
		angs(129)=	36.000000
		mags(130)=	0.593750
		angs(130)=	48.000000
		mags(131)=	0.593750
		angs(131)=	60.000000
		mags(132)=	0.593750
		angs(132)=	72.000000
		mags(133)=	0.593750
		angs(133)=	84.000000
		mags(134)=	0.593750
		angs(134)=	96.000000
		mags(135)=	0.593750
		angs(135)=	108.000000
		mags(136)=	0.593750
		angs(136)=	120.000000
		mags(137)=	0.593750
		angs(137)=	132.000000
		mags(138)=	0.593750
		angs(138)=	144.000000
		mags(139)=	0.593750
		angs(139)=	156.000000
		mags(140)=	0.593750
		angs(140)=	168.000000
		mags(141)=	0.593750
		angs(141)=	180.000000
		mags(142)=	0.593750
		angs(142)=	192.000000
		mags(143)=	0.593750
		angs(143)=	204.000000
		mags(144)=	0.593750
		angs(144)=	216.000000
		mags(145)=	0.593750
		angs(145)=	228.000000
		mags(146)=	0.593750
		angs(146)=	240.000000
		mags(147)=	0.593750
		angs(147)=	252.000000
		mags(148)=	0.593750
		angs(148)=	264.000000
		mags(149)=	0.593750
		angs(149)=	276.000000
		mags(150)=	0.593750
		angs(150)=	288.000000
		mags(151)=	0.593750
		angs(151)=	300.000000
		mags(152)=	0.593750
		angs(152)=	312.000000
		mags(153)=	0.593750
		angs(153)=	324.000000
		mags(154)=	0.593750
		angs(154)=	336.000000
		mags(155)=	0.593750
		angs(155)=	348.000000
		mags(156)=	0.475000
		angs(156)=	0.000000
		mags(157)=	0.475000
		angs(157)=	15.000000
		mags(158)=	0.475000
		angs(158)=	30.000000
		mags(159)=	0.475000
		angs(159)=	45.000000
		mags(160)=	0.475000
		angs(160)=	60.000000
		mags(161)=	0.475000
		angs(161)=	75.000000
		mags(162)=	0.475000
		angs(162)=	90.000000
		mags(163)=	0.475000
		angs(163)=	105.000000
		mags(164)=	0.475000
		angs(164)=	120.000000
		mags(165)=	0.475000
		angs(165)=	135.000000
		mags(166)=	0.475000
		angs(166)=	150.000000
		mags(167)=	0.475000
		angs(167)=	165.000000
		mags(168)=	0.475000
		angs(168)=	180.000000
		mags(169)=	0.475000
		angs(169)=	195.000000
		mags(170)=	0.475000
		angs(170)=	210.000000
		mags(171)=	0.475000
		angs(171)=	225.000000
		mags(172)=	0.475000
		angs(172)=	240.000000
		mags(173)=	0.475000
		angs(173)=	255.000000
		mags(174)=	0.475000
		angs(174)=	270.000000
		mags(175)=	0.475000
		angs(175)=	285.000000
		mags(176)=	0.475000
		angs(176)=	300.000000
		mags(177)=	0.475000
		angs(177)=	315.000000
		mags(178)=	0.475000
		angs(178)=	330.000000
		mags(179)=	0.475000
		angs(179)=	345.000000
		mags(180)=	0.356250
		angs(180)=	0.000000
		mags(181)=	0.356250
		angs(181)=	20.000000
		mags(182)=	0.356250
		angs(182)=	40.000000
		mags(183)=	0.356250
		angs(183)=	60.000000
		mags(184)=	0.356250
		angs(184)=	80.000000
		mags(185)=	0.356250
		angs(185)=	100.000000
		mags(186)=	0.356250
		angs(186)=	120.000000
		mags(187)=	0.356250
		angs(187)=	140.000000
		mags(188)=	0.356250
		angs(188)=	160.000000
		mags(189)=	0.356250
		angs(189)=	180.000000
		mags(190)=	0.356250
		angs(190)=	200.000000
		mags(191)=	0.356250
		angs(191)=	220.000000
		mags(192)=	0.356250
		angs(192)=	240.000000
		mags(193)=	0.356250
		angs(193)=	260.000000
		mags(194)=	0.356250
		angs(194)=	280.000000
		mags(195)=	0.356250
		angs(195)=	300.000000
		mags(196)=	0.356250
		angs(196)=	320.000000
		mags(197)=	0.356250
		angs(197)=	340.000000
		mags(198)=	0.237500
		angs(198)=	0.000000
		mags(199)=	0.237500
		angs(199)=	30.000000
		mags(200)=	0.237500
		angs(200)=	60.000000
		mags(201)=	0.237500
		angs(201)=	90.000000
		mags(202)=	0.237500
		angs(202)=	120.000000
		mags(203)=	0.237500
		angs(203)=	150.000000
		mags(204)=	0.237500
		angs(204)=	180.000000
		mags(205)=	0.237500
		angs(205)=	210.000000
		mags(206)=	0.237500
		angs(206)=	240.000000
		mags(207)=	0.237500
		angs(207)=	270.000000
		mags(208)=	0.237500
		angs(208)=	300.000000
		mags(209)=	0.237500
		angs(209)=	330.000000
		mags(210)=	0.118750
		angs(210)=	0.000000
		mags(211)=	0.118750
		angs(211)=	60.000000
		mags(212)=	0.118750
		angs(212)=	120.000000
		mags(213)=	0.118750
		angs(213)=	180.000000
		mags(214)=	0.118750
		angs(214)=	240.000000
		mags(215)=	0.118750
		angs(215)=	300.000000
		mags(216)=	0.000000
		angs(216)=	0.000000

	Case 3
		nPts = 330
		ReDim mags(nPts)
		ReDim angs(nPts)
		mags(0)=	0.950000
		angs(0)=	0.000000
		mags(1)=	0.950000
		angs(1)=	6.000000
		mags(2)=	0.950000
		angs(2)=	12.000000
		mags(3)=	0.950000
		angs(3)=	18.000000
		mags(4)=	0.950000
		angs(4)=	24.000000
		mags(5)=	0.950000
		angs(5)=	30.000000
		mags(6)=	0.950000
		angs(6)=	36.000000
		mags(7)=	0.950000
		angs(7)=	42.000000
		mags(8)=	0.950000
		angs(8)=	48.000000
		mags(9)=	0.950000
		angs(9)=	54.000000
		mags(10)=	0.950000
		angs(10)=	60.000000
		mags(11)=	0.950000
		angs(11)=	66.000000
		mags(12)=	0.950000
		angs(12)=	72.000000
		mags(13)=	0.950000
		angs(13)=	78.000000
		mags(14)=	0.950000
		angs(14)=	84.000000
		mags(15)=	0.950000
		angs(15)=	90.000000
		mags(16)=	0.950000
		angs(16)=	96.000000
		mags(17)=	0.950000
		angs(17)=	102.000000
		mags(18)=	0.950000
		angs(18)=	108.000000
		mags(19)=	0.950000
		angs(19)=	114.000000
		mags(20)=	0.950000
		angs(20)=	120.000000
		mags(21)=	0.950000
		angs(21)=	126.000000
		mags(22)=	0.950000
		angs(22)=	132.000000
		mags(23)=	0.950000
		angs(23)=	138.000000
		mags(24)=	0.950000
		angs(24)=	144.000000
		mags(25)=	0.950000
		angs(25)=	150.000000
		mags(26)=	0.950000
		angs(26)=	156.000000
		mags(27)=	0.950000
		angs(27)=	162.000000
		mags(28)=	0.950000
		angs(28)=	168.000000
		mags(29)=	0.950000
		angs(29)=	174.000000
		mags(30)=	0.950000
		angs(30)=	180.000000
		mags(31)=	0.950000
		angs(31)=	186.000000
		mags(32)=	0.950000
		angs(32)=	192.000000
		mags(33)=	0.950000
		angs(33)=	198.000000
		mags(34)=	0.950000
		angs(34)=	204.000000
		mags(35)=	0.950000
		angs(35)=	210.000000
		mags(36)=	0.950000
		angs(36)=	216.000000
		mags(37)=	0.950000
		angs(37)=	222.000000
		mags(38)=	0.950000
		angs(38)=	228.000000
		mags(39)=	0.950000
		angs(39)=	234.000000
		mags(40)=	0.950000
		angs(40)=	240.000000
		mags(41)=	0.950000
		angs(41)=	246.000000
		mags(42)=	0.950000
		angs(42)=	252.000000
		mags(43)=	0.950000
		angs(43)=	258.000000
		mags(44)=	0.950000
		angs(44)=	264.000000
		mags(45)=	0.950000
		angs(45)=	270.000000
		mags(46)=	0.950000
		angs(46)=	276.000000
		mags(47)=	0.950000
		angs(47)=	282.000000
		mags(48)=	0.950000
		angs(48)=	288.000000
		mags(49)=	0.950000
		angs(49)=	294.000000
		mags(50)=	0.950000
		angs(50)=	300.000000
		mags(51)=	0.950000
		angs(51)=	306.000000
		mags(52)=	0.950000
		angs(52)=	312.000000
		mags(53)=	0.950000
		angs(53)=	318.000000
		mags(54)=	0.950000
		angs(54)=	324.000000
		mags(55)=	0.950000
		angs(55)=	330.000000
		mags(56)=	0.950000
		angs(56)=	336.000000
		mags(57)=	0.950000
		angs(57)=	342.000000
		mags(58)=	0.950000
		angs(58)=	348.000000
		mags(59)=	0.950000
		angs(59)=	354.000000
		mags(60)=	0.855000
		angs(60)=	0.000000
		mags(61)=	0.855000
		angs(61)=	6.666667
		mags(62)=	0.855000
		angs(62)=	13.333333
		mags(63)=	0.855000
		angs(63)=	20.000000
		mags(64)=	0.855000
		angs(64)=	26.666667
		mags(65)=	0.855000
		angs(65)=	33.333333
		mags(66)=	0.855000
		angs(66)=	40.000000
		mags(67)=	0.855000
		angs(67)=	46.666667
		mags(68)=	0.855000
		angs(68)=	53.333333
		mags(69)=	0.855000
		angs(69)=	60.000000
		mags(70)=	0.855000
		angs(70)=	66.666667
		mags(71)=	0.855000
		angs(71)=	73.333333
		mags(72)=	0.855000
		angs(72)=	80.000000
		mags(73)=	0.855000
		angs(73)=	86.666667
		mags(74)=	0.855000
		angs(74)=	93.333333
		mags(75)=	0.855000
		angs(75)=	100.000000
		mags(76)=	0.855000
		angs(76)=	106.666667
		mags(77)=	0.855000
		angs(77)=	113.333333
		mags(78)=	0.855000
		angs(78)=	120.000000
		mags(79)=	0.855000
		angs(79)=	126.666667
		mags(80)=	0.855000
		angs(80)=	133.333333
		mags(81)=	0.855000
		angs(81)=	140.000000
		mags(82)=	0.855000
		angs(82)=	146.666667
		mags(83)=	0.855000
		angs(83)=	153.333333
		mags(84)=	0.855000
		angs(84)=	160.000000
		mags(85)=	0.855000
		angs(85)=	166.666667
		mags(86)=	0.855000
		angs(86)=	173.333333
		mags(87)=	0.855000
		angs(87)=	180.000000
		mags(88)=	0.855000
		angs(88)=	186.666667
		mags(89)=	0.855000
		angs(89)=	193.333333
		mags(90)=	0.855000
		angs(90)=	200.000000
		mags(91)=	0.855000
		angs(91)=	206.666667
		mags(92)=	0.855000
		angs(92)=	213.333333
		mags(93)=	0.855000
		angs(93)=	220.000000
		mags(94)=	0.855000
		angs(94)=	226.666667
		mags(95)=	0.855000
		angs(95)=	233.333333
		mags(96)=	0.855000
		angs(96)=	240.000000
		mags(97)=	0.855000
		angs(97)=	246.666667
		mags(98)=	0.855000
		angs(98)=	253.333333
		mags(99)=	0.855000
		angs(99)=	260.000000
		mags(100)=	0.855000
		angs(100)=	266.666667
		mags(101)=	0.855000
		angs(101)=	273.333333
		mags(102)=	0.855000
		angs(102)=	280.000000
		mags(103)=	0.855000
		angs(103)=	286.666667
		mags(104)=	0.855000
		angs(104)=	293.333333
		mags(105)=	0.855000
		angs(105)=	300.000000
		mags(106)=	0.855000
		angs(106)=	306.666667
		mags(107)=	0.855000
		angs(107)=	313.333333
		mags(108)=	0.855000
		angs(108)=	320.000000
		mags(109)=	0.855000
		angs(109)=	326.666667
		mags(110)=	0.855000
		angs(110)=	333.333333
		mags(111)=	0.855000
		angs(111)=	340.000000
		mags(112)=	0.855000
		angs(112)=	346.666667
		mags(113)=	0.855000
		angs(113)=	353.333333
		mags(114)=	0.760000
		angs(114)=	0.000000
		mags(115)=	0.760000
		angs(115)=	7.500000
		mags(116)=	0.760000
		angs(116)=	15.000000
		mags(117)=	0.760000
		angs(117)=	22.500000
		mags(118)=	0.760000
		angs(118)=	30.000000
		mags(119)=	0.760000
		angs(119)=	37.500000
		mags(120)=	0.760000
		angs(120)=	45.000000
		mags(121)=	0.760000
		angs(121)=	52.500000
		mags(122)=	0.760000
		angs(122)=	60.000000
		mags(123)=	0.760000
		angs(123)=	67.500000
		mags(124)=	0.760000
		angs(124)=	75.000000
		mags(125)=	0.760000
		angs(125)=	82.500000
		mags(126)=	0.760000
		angs(126)=	90.000000
		mags(127)=	0.760000
		angs(127)=	97.500000
		mags(128)=	0.760000
		angs(128)=	105.000000
		mags(129)=	0.760000
		angs(129)=	112.500000
		mags(130)=	0.760000
		angs(130)=	120.000000
		mags(131)=	0.760000
		angs(131)=	127.500000
		mags(132)=	0.760000
		angs(132)=	135.000000
		mags(133)=	0.760000
		angs(133)=	142.500000
		mags(134)=	0.760000
		angs(134)=	150.000000
		mags(135)=	0.760000
		angs(135)=	157.500000
		mags(136)=	0.760000
		angs(136)=	165.000000
		mags(137)=	0.760000
		angs(137)=	172.500000
		mags(138)=	0.760000
		angs(138)=	180.000000
		mags(139)=	0.760000
		angs(139)=	187.500000
		mags(140)=	0.760000
		angs(140)=	195.000000
		mags(141)=	0.760000
		angs(141)=	202.500000
		mags(142)=	0.760000
		angs(142)=	210.000000
		mags(143)=	0.760000
		angs(143)=	217.500000
		mags(144)=	0.760000
		angs(144)=	225.000000
		mags(145)=	0.760000
		angs(145)=	232.500000
		mags(146)=	0.760000
		angs(146)=	240.000000
		mags(147)=	0.760000
		angs(147)=	247.500000
		mags(148)=	0.760000
		angs(148)=	255.000000
		mags(149)=	0.760000
		angs(149)=	262.500000
		mags(150)=	0.760000
		angs(150)=	270.000000
		mags(151)=	0.760000
		angs(151)=	277.500000
		mags(152)=	0.760000
		angs(152)=	285.000000
		mags(153)=	0.760000
		angs(153)=	292.500000
		mags(154)=	0.760000
		angs(154)=	300.000000
		mags(155)=	0.760000
		angs(155)=	307.500000
		mags(156)=	0.760000
		angs(156)=	315.000000
		mags(157)=	0.760000
		angs(157)=	322.500000
		mags(158)=	0.760000
		angs(158)=	330.000000
		mags(159)=	0.760000
		angs(159)=	337.500000
		mags(160)=	0.760000
		angs(160)=	345.000000
		mags(161)=	0.760000
		angs(161)=	352.500000
		mags(162)=	0.665000
		angs(162)=	0.000000
		mags(163)=	0.665000
		angs(163)=	8.571429
		mags(164)=	0.665000
		angs(164)=	17.142857
		mags(165)=	0.665000
		angs(165)=	25.714286
		mags(166)=	0.665000
		angs(166)=	34.285714
		mags(167)=	0.665000
		angs(167)=	42.857143
		mags(168)=	0.665000
		angs(168)=	51.428571
		mags(169)=	0.665000
		angs(169)=	60.000000
		mags(170)=	0.665000
		angs(170)=	68.571429
		mags(171)=	0.665000
		angs(171)=	77.142857
		mags(172)=	0.665000
		angs(172)=	85.714286
		mags(173)=	0.665000
		angs(173)=	94.285714
		mags(174)=	0.665000
		angs(174)=	102.857143
		mags(175)=	0.665000
		angs(175)=	111.428571
		mags(176)=	0.665000
		angs(176)=	120.000000
		mags(177)=	0.665000
		angs(177)=	128.571429
		mags(178)=	0.665000
		angs(178)=	137.142857
		mags(179)=	0.665000
		angs(179)=	145.714286
		mags(180)=	0.665000
		angs(180)=	154.285714
		mags(181)=	0.665000
		angs(181)=	162.857143
		mags(182)=	0.665000
		angs(182)=	171.428571
		mags(183)=	0.665000
		angs(183)=	180.000000
		mags(184)=	0.665000
		angs(184)=	188.571429
		mags(185)=	0.665000
		angs(185)=	197.142857
		mags(186)=	0.665000
		angs(186)=	205.714286
		mags(187)=	0.665000
		angs(187)=	214.285714
		mags(188)=	0.665000
		angs(188)=	222.857143
		mags(189)=	0.665000
		angs(189)=	231.428571
		mags(190)=	0.665000
		angs(190)=	240.000000
		mags(191)=	0.665000
		angs(191)=	248.571429
		mags(192)=	0.665000
		angs(192)=	257.142857
		mags(193)=	0.665000
		angs(193)=	265.714286
		mags(194)=	0.665000
		angs(194)=	274.285714
		mags(195)=	0.665000
		angs(195)=	282.857143
		mags(196)=	0.665000
		angs(196)=	291.428571
		mags(197)=	0.665000
		angs(197)=	300.000000
		mags(198)=	0.665000
		angs(198)=	308.571429
		mags(199)=	0.665000
		angs(199)=	317.142857
		mags(200)=	0.665000
		angs(200)=	325.714286
		mags(201)=	0.665000
		angs(201)=	334.285714
		mags(202)=	0.665000
		angs(202)=	342.857143
		mags(203)=	0.665000
		angs(203)=	351.428571
		mags(204)=	0.570000
		angs(204)=	0.000000
		mags(205)=	0.570000
		angs(205)=	10.000000
		mags(206)=	0.570000
		angs(206)=	20.000000
		mags(207)=	0.570000
		angs(207)=	30.000000
		mags(208)=	0.570000
		angs(208)=	40.000000
		mags(209)=	0.570000
		angs(209)=	50.000000
		mags(210)=	0.570000
		angs(210)=	60.000000
		mags(211)=	0.570000
		angs(211)=	70.000000
		mags(212)=	0.570000
		angs(212)=	80.000000
		mags(213)=	0.570000
		angs(213)=	90.000000
		mags(214)=	0.570000
		angs(214)=	100.000000
		mags(215)=	0.570000
		angs(215)=	110.000000
		mags(216)=	0.570000
		angs(216)=	120.000000
		mags(217)=	0.570000
		angs(217)=	130.000000
		mags(218)=	0.570000
		angs(218)=	140.000000
		mags(219)=	0.570000
		angs(219)=	150.000000
		mags(220)=	0.570000
		angs(220)=	160.000000
		mags(221)=	0.570000
		angs(221)=	170.000000
		mags(222)=	0.570000
		angs(222)=	180.000000
		mags(223)=	0.570000
		angs(223)=	190.000000
		mags(224)=	0.570000
		angs(224)=	200.000000
		mags(225)=	0.570000
		angs(225)=	210.000000
		mags(226)=	0.570000
		angs(226)=	220.000000
		mags(227)=	0.570000
		angs(227)=	230.000000
		mags(228)=	0.570000
		angs(228)=	240.000000
		mags(229)=	0.570000
		angs(229)=	250.000000
		mags(230)=	0.570000
		angs(230)=	260.000000
		mags(231)=	0.570000
		angs(231)=	270.000000
		mags(232)=	0.570000
		angs(232)=	280.000000
		mags(233)=	0.570000
		angs(233)=	290.000000
		mags(234)=	0.570000
		angs(234)=	300.000000
		mags(235)=	0.570000
		angs(235)=	310.000000
		mags(236)=	0.570000
		angs(236)=	320.000000
		mags(237)=	0.570000
		angs(237)=	330.000000
		mags(238)=	0.570000
		angs(238)=	340.000000
		mags(239)=	0.570000
		angs(239)=	350.000000
		mags(240)=	0.475000
		angs(240)=	0.000000
		mags(241)=	0.475000
		angs(241)=	12.000000
		mags(242)=	0.475000
		angs(242)=	24.000000
		mags(243)=	0.475000
		angs(243)=	36.000000
		mags(244)=	0.475000
		angs(244)=	48.000000
		mags(245)=	0.475000
		angs(245)=	60.000000
		mags(246)=	0.475000
		angs(246)=	72.000000
		mags(247)=	0.475000
		angs(247)=	84.000000
		mags(248)=	0.475000
		angs(248)=	96.000000
		mags(249)=	0.475000
		angs(249)=	108.000000
		mags(250)=	0.475000
		angs(250)=	120.000000
		mags(251)=	0.475000
		angs(251)=	132.000000
		mags(252)=	0.475000
		angs(252)=	144.000000
		mags(253)=	0.475000
		angs(253)=	156.000000
		mags(254)=	0.475000
		angs(254)=	168.000000
		mags(255)=	0.475000
		angs(255)=	180.000000
		mags(256)=	0.475000
		angs(256)=	192.000000
		mags(257)=	0.475000
		angs(257)=	204.000000
		mags(258)=	0.475000
		angs(258)=	216.000000
		mags(259)=	0.475000
		angs(259)=	228.000000
		mags(260)=	0.475000
		angs(260)=	240.000000
		mags(261)=	0.475000
		angs(261)=	252.000000
		mags(262)=	0.475000
		angs(262)=	264.000000
		mags(263)=	0.475000
		angs(263)=	276.000000
		mags(264)=	0.475000
		angs(264)=	288.000000
		mags(265)=	0.475000
		angs(265)=	300.000000
		mags(266)=	0.475000
		angs(266)=	312.000000
		mags(267)=	0.475000
		angs(267)=	324.000000
		mags(268)=	0.475000
		angs(268)=	336.000000
		mags(269)=	0.475000
		angs(269)=	348.000000
		mags(270)=	0.380000
		angs(270)=	0.000000
		mags(271)=	0.380000
		angs(271)=	15.000000
		mags(272)=	0.380000
		angs(272)=	30.000000
		mags(273)=	0.380000
		angs(273)=	45.000000
		mags(274)=	0.380000
		angs(274)=	60.000000
		mags(275)=	0.380000
		angs(275)=	75.000000
		mags(276)=	0.380000
		angs(276)=	90.000000
		mags(277)=	0.380000
		angs(277)=	105.000000
		mags(278)=	0.380000
		angs(278)=	120.000000
		mags(279)=	0.380000
		angs(279)=	135.000000
		mags(280)=	0.380000
		angs(280)=	150.000000
		mags(281)=	0.380000
		angs(281)=	165.000000
		mags(282)=	0.380000
		angs(282)=	180.000000
		mags(283)=	0.380000
		angs(283)=	195.000000
		mags(284)=	0.380000
		angs(284)=	210.000000
		mags(285)=	0.380000
		angs(285)=	225.000000
		mags(286)=	0.380000
		angs(286)=	240.000000
		mags(287)=	0.380000
		angs(287)=	255.000000
		mags(288)=	0.380000
		angs(288)=	270.000000
		mags(289)=	0.380000
		angs(289)=	285.000000
		mags(290)=	0.380000
		angs(290)=	300.000000
		mags(291)=	0.380000
		angs(291)=	315.000000
		mags(292)=	0.380000
		angs(292)=	330.000000
		mags(293)=	0.380000
		angs(293)=	345.000000
		mags(294)=	0.285000
		angs(294)=	0.000000
		mags(295)=	0.285000
		angs(295)=	20.000000
		mags(296)=	0.285000
		angs(296)=	40.000000
		mags(297)=	0.285000
		angs(297)=	60.000000
		mags(298)=	0.285000
		angs(298)=	80.000000
		mags(299)=	0.285000
		angs(299)=	100.000000
		mags(300)=	0.285000
		angs(300)=	120.000000
		mags(301)=	0.285000
		angs(301)=	140.000000
		mags(302)=	0.285000
		angs(302)=	160.000000
		mags(303)=	0.285000
		angs(303)=	180.000000
		mags(304)=	0.285000
		angs(304)=	200.000000
		mags(305)=	0.285000
		angs(305)=	220.000000
		mags(306)=	0.285000
		angs(306)=	240.000000
		mags(307)=	0.285000
		angs(307)=	260.000000
		mags(308)=	0.285000
		angs(308)=	280.000000
		mags(309)=	0.285000
		angs(309)=	300.000000
		mags(310)=	0.285000
		angs(310)=	320.000000
		mags(311)=	0.285000
		angs(311)=	340.000000
		mags(312)=	0.190000
		angs(312)=	0.000000
		mags(313)=	0.190000
		angs(313)=	30.000000
		mags(314)=	0.190000
		angs(314)=	60.000000
		mags(315)=	0.190000
		angs(315)=	90.000000
		mags(316)=	0.190000
		angs(316)=	120.000000
		mags(317)=	0.190000
		angs(317)=	150.000000
		mags(318)=	0.190000
		angs(318)=	180.000000
		mags(319)=	0.190000
		angs(319)=	210.000000
		mags(320)=	0.190000
		angs(320)=	240.000000
		mags(321)=	0.190000
		angs(321)=	270.000000
		mags(322)=	0.190000
		angs(322)=	300.000000
		mags(323)=	0.190000
		angs(323)=	330.000000
		mags(324)=	0.095000
		angs(324)=	0.000000
		mags(325)=	0.095000
		angs(325)=	60.000000
		mags(326)=	0.095000
		angs(326)=	120.000000
		mags(327)=	0.095000
		angs(327)=	180.000000
		mags(328)=	0.095000
		angs(328)=	240.000000
		mags(329)=	0.095000
		angs(329)=	300.000000
		mags(330)=	0.000000
		angs(330)=	0.000000

	End Select

	PointDict.RemoveAll()

	n = 0
	For i=UBound(mags) To 0 Step -1
		re = mags(i)*Cos(degToRad(angs(i)))
		im = -mags(i)*Sin(degToRad(angs(i)))
		xx = Rad*re
		yy = Rad*im
		deltaxx = MC*Cos(degToRad(AC))
		deltayy = MC*Sin(degToRad(AC))
		xx = xx + deltaxx
		yy = yy + deltayy
		mag = Sqr(xx*xx + yy*yy)
		ang = atan2(yy,xx)
		If (mag < MagMax) Then
			lppt.r = xx
			lppt.i = yy
			PointDict(n) = lppt
			n = n + 1
		End If
	Next i

	If (writeGraph) Then
		drawPointsOnGraph(True,False)
	End If

End Function
Function parseOutputEquations() As Boolean

	Dim oe As Equation
	Dim oes As Equations
	Dim oed As OutputEquationDocument
	Dim oeds As OutputEquationDocuments
	Dim oeName As String
	Dim oeValue As String
	Dim names()
	Dim nNames As Integer
	Dim values() As String
	Dim nValues As Integer
	Dim curValues()
	Dim curValue As String
	Dim fixValue As String
	Dim i As Integer
	Dim temp As String

	If (DebugMode) Then
		Debug.Print vbNewLine + "Parsing Output Equations..."
	End If

	Set oeds = Project.OutputEquationDocuments
	For Each oed In oeds
		Set oes = oed.Equations
		For Each oe In oes
			If (InStr(oe.Expression,"=") <> 0) Then
				oeName = getEqnDictName(oed.Name,(Split(oe.Expression,"=")(0)))
				oeValue = Trim(Split(oe.Expression,"=")(1))
				If (InStr(oeValue,":") = 0) Then
					oeValue = Replace(oeValue," ","")
					oeValue = stringReplace(oeValue,"+-()[]/*, ",SplitChar)
				Else
					oeValue = Split(oeValue,":")(0)
				End If
				values = Split(oeValue,SplitChar)
				nValues = UBound(values)
				oeValue = SplitChar
				For i=0 To nValues
					curValue = values(i)
					If (IsNumeric(curValue) = False) Then
						fixValue = getMeasSource(curValue)
						If (isDataSource(fixValue) = True) Then
							curValue = fixValue
						End If
						temp = SplitChar + curValue + SplitChar
						If (InStr(oeValue,temp) = 0) Then
							oeValue = oeValue + curValue + SplitChar
						End If
					End If
				Next i
				oeValue = removeRedundantChars(oeValue,SplitChar)
				'Debug.Print oeName
				EqnDict(oeName) = oeValue
			End If
		Next oe
	Next oed

End Function
Function getMeasSource (measName As String) As String

	Dim mName As String

	mName = measName

	'For plotvs need to remove all the extra syntax
	If (Left(mName,1) = ":") Then
		mName = Right(mName,Len(mName)-8)
		mName = stringReplace(mName,"""","")
	ElseIf (Right(mName,2) = """" + ")") Then
		mName = Left(mName,Len(mName)-2)
		mName = stringReplace(mName,"""","")
	End If

	mName = Split(mName,":")(0)
	mName = Split(mName,".")(0)
	getMeasSource = mName

End Function
Function isDataSource (source As String) As Boolean

	Dim ret As Boolean

	If (source <> "") Then
		If (Project.DataFiles.Exists(source) = True) Then
			ret = True
		ElseIf(Project.Schematics.Exists(source) = True) Then
			ret = True
		ElseIf (Project.EMStructures.Exists(source) = True) Then
			ret = True
		Else
			ret = False
		End If
	Else
		ret = False
	End If

	isDataSource = ret

End Function
Function removeRedundantChars(origString As String, searchChar As String) As String

	Dim temp() As String
	Dim ret As String
	Dim i As Integer

	temp = Split(origString,searchChar)

	ret = SplitChar
	For i=0 To UBound(temp)
		If (temp(i) <> "") Then
			ret = ret + temp(i) + searchChar
		End If
	Next i

	'Debug.Print origString + vbTab + ret

	removeRedundantChars = ret

End Function
Function getOutputEquationSources(oedName As String, oeName As String) As Boolean

	Dim dictName As String
	Dim oe As Equation
	Dim oeValue As String
	Dim nValues As Integer
	Dim curValues()
	Dim curValue As String
	Dim i As Integer
	Dim ret As Boolean
	Dim entryExists As Boolean
	Dim mSource As String
	Dim mType As String
	Dim dependsDict As Dictionary
	Set dependsDict = New Dictionary

	dictName = getEqnDictName(oedName,oeName)

	If (EqnDict.Exists(dictName) = True) Then
		If (DebugMode) Then
			Debug.Print vbTab + vbTab + dictName
		End If

		addValuesToDict(EqnDict(dictName),PendingDict,SplitChar,dictName)
		If (DebugMode) Then
			Debug.Print vbTab + vbTab +vbTab + "Expression:" + vbTab + EqnDict(dictName)
		End If

		While (PendingDict.Count <> 0)
			curValues = PendingDict.Keys
			curValue = curValues(0)
			dictName = getEqnDictName(oedName,curValue)
			PendingDict.Remove(curValue)
			If (curValue <> "") Then
				entryExists = False
				If (dependsDict.Exists(curValue) = True) Then
					entryExists = True
				End If
				dependsDict(curValue) = curValue

				mSource = Split(curValue,".")(0)

				If (EqnDict.Exists(dictName) = True) Then
					addValuesToDict(EqnDict(dictName),PendingDict,SplitChar,dictName)
					If (entryExists = False) Then
						If (DebugMode) Then
							Debug.Print vbTab + vbTab + vbTab + "Equation:" + vbTab + curValue
						End If
					End If
				ElseIf (isDataSource(mSource) = True) Then
					recordSource(curValue)
					If (entryExists = False) Then
						If (DebugMode) Then
							Debug.Print vbTab + vbTab + vbTab + "Source:" + vbTab + curValue
						End If
					End If
				Else
					If (entryExists = False) Then
						If (DebugMode) Then
							Debug.Print vbTab + vbTab + vbTab + "Function:" + vbTab + curValue
						End If
					End If
				End If

			End If
		Wend

		curValues = dependsDict.Keys
		nValues = UBound(curValues)
		For i=0 To nValues
			If (DebugMode) Then
				'Debug.Print vbTab + vbTab + curValues(i)
			End If
		Next i
		dependsDict.RemoveAll()

		ret = True
	Else
		ret = False
	End If

	getOutputEquationSources = ret

End Function
Function getEqnDictName(oedName As String, oeName As String) As String

	getEqnDictName = Trim(oedName + SplitChar + oeName)

End Function
Function addValuesToDict(token As String, dict As Dictionary, SplitChar As String, leftSide) As Boolean

	Dim temp() As String
	Dim realLeftSide As String
	Dim i As Integer

	realLeftSide = leftSide
	If (InStr(leftSide,SplitChar)) Then
		realLeftSide = Split(leftSide,SplitChar)(1)
	End If

	temp = Split(token,SplitChar)
	For i=0 To UBound(temp)
		'don't allow circular reference
		If (temp(i) <> realLeftSide) And (temp(i) <> "") Then
			dict(temp(i)) = temp(i)
		End If
	Next i

End Function
Function recordSource(source As String) As Boolean

	'The source still has the simulator extension like ".AP" in it
	'so strip it off...
	Dim mSource As String
	mSource = Split(source,".")(0)

	If (isDataSource(mSource) = True) Then
		SourceDict(mSource) = mSource
	'ElseIf (getOutputEquationSources(source) = True) Then
		'Nothing
	Else
		'Nothing
	End If

End Function
Function openHelp() As String

	Dim cmd As String

	cmd = "Users_Guide.chm::/output/load_pull_wiz2.html"
	cmd = "hh mk:@MSITStore:" + MWOffice.Path + cmd
	Shell(cmd,vbMaximizedFocus)

End Function

Sub alphaSort(ByRef vArray As Variant)
    Dim TempVal As Variant
    Dim i As Long, GapSize As Long, CurPos As Long
    Dim FirstRow As Long, LastRow As Long, NumRows As Long
    FirstRow = LBound(vArray)
    LastRow = UBound(vArray)
    NumRows = LastRow - FirstRow + 1
    Do
      GapSize = GapSize * 3 + 1
    Loop Until GapSize > NumRows
    Do
      GapSize = GapSize \ 3
      For i = (GapSize + FirstRow) To LastRow
        CurPos = i
        TempVal = vArray(i)
        While compareResult(vArray(CurPos - GapSize),TempVal)
          vArray(CurPos) = vArray(CurPos - GapSize)
          CurPos = CurPos - GapSize
          If (CurPos - GapSize) < FirstRow Then Exit While
        Wend
        vArray(CurPos) = TempVal
      Next
    Loop Until GapSize = 1
End Sub
'Helper function for alphaSort - does nothing on it's own
Function compareResult( Value1 As Variant, Value2 As Variant)
	compareResult = (Value1 > Value2) 	'very ugly here because you need to specify the member to compare (need a way to pass that into the ShellSort sub.)
End Function
