' PADS Logic BOM Output
' By Fanniu (Sparkamax@Gmail.com)
Dim fn As String

Sub Main
	fn = ActiveDocument
	If fn = "" Then
		fn = "Untitled"
	End If
	tempFile = DefaultFilePath & "\temp.txt"
	Open tempFile For Output As #1
	StatusBarText = "Generating report..."
	Print #1, "PARTS"; vbTab; "SYSID"; vbTab; "QTY"; vbTab; "Symbol"
	For Each pkg in ActiveDocument.PartTypes
		Print #1, pkg.Name; vbTab;
		qty = 0
		symbol = ""
		For Each part In pkg.Components
			sysid = AttrValue(part, "SYSID")
			qty = qty+1
			symbol = symbol + part.Name + ", "
		Next		
		symbol_len = Len(symbol)
		symbol = Mid(symbol,1, symbol_len - 2)
		Print #1, sysid; vbTab; qty; vbTab; symbol;
		Print #1
	Next pkg
	StatusBarText = ""
	Close #1
	ExportToExcel
End Sub

Sub ExportToExcel
	FillClipboard
	Dim xl As Object
	On Error Resume Next
	Set xl =  GetObject(,"Excel.Application")
	On Error GoTo ExcelError	' Enable error trapping.
	If xl Is Nothing Then
		Set xl =  CreateObject("Excel.Application")
	End If
	xl.Visible = True
	xl.Workbooks.Add
	xl.ActiveSheet.Paste
	xl.Range("A1").Select
	Exit Sub    

ExcelError:
	MsgBox Err.Description, vbExclamation, "Error Running Excel"
	On Error GoTo 0 ' Disable error trapping.    
	Exit Sub
End Sub

Sub FillClipboard
	StatusBarText = "Export Data To Clipboard..."
	' Load whole file to string variable    
	tempFile = DefaultFilePath & "\temp.txt"
	Open tempFile  For Input As #1
	L = LOF(1)
	AllData$ = Input$(L,1)
	Close #1
	'Copy whole data to clipboard
	Clipboard AllData$ 
	Kill tempFile
	StatusBarText = ""
End Sub
Function AttrValue (comp As Object, atrName As String) As String
	If comp.Attributes(atrName) Is Nothing Then
		AttrValue = ""
	Else
		AttrValue = comp.Attributes(atrName).Value
	End If
End Function
