'# MWS Version: Version 2006B.4 - Sep  9 2007 - 21:59:50

'# length = mm
'# frequency = MHz
'# time = ns
'# frequency range: fmin = 0 fmax = 500


'@ use template: RFID

' Template for RFID Antenna
' =========================
' (CSTxMWSxONLY)
' draw the bounding box
Plot.DrawBox True
' set units to mm, ghz
With Units 
     .Geometry "mm" 
     .Frequency "ghz" 
     .Time "ns" 
End With 
' set background material to vacuum
With Background 
     .Type "Normal" 
     .Epsilon "1.0" 
     .Mue "1.0" 
     .XminSpace "0.0" 
     .XmaxSpace "0.0" 
     .YminSpace "0.0" 
     .YmaxSpace "0.0" 
     .ZminSpace "0.0" 
     .ZmaxSpace "0.0" 
End With 
' set boundary conditions to open+add space
With Boundary
     .Xmin "expanded open" 
     .Xmax "expanded open" 
     .Ymin "expanded open" 
     .Ymax "expanded open" 
     .Zmin "expanded open" 
     .Zmax "expanded open" 
     .Xsymmetry "none" 
     .Ysymmetry "none" 
     .Zsymmetry "none" 
End With
' optimize mesh settings for planar structures
With Mesh 
     .MergeThinPECLayerFixpoints "True" 
     .RatioLimit "50" 
     .AutomeshRefineAtPecLines "True", "4"
End With 
Mesh.FPBAAvoidNonRegUnite "True" 
' change mesh adaption scheme to energy 
' 		(planar structures tend to store high energy 
'     	 locally at edges rather than globally in volume)
MeshAdaption3D.SetAdaptionStrategy "Energy"

'@ define units

With Units 
     .Geometry "mm" 
     .Frequency "MHz" 
     .Time "ns" 
     .Temperature "Celsius" 
     .Voltage "V" 
     .Current "A" 
     .Resistance "Ohm" 
     .Conductance "S" 
     .Capacitance "pF" 
     .Inductance "nH" 
End With

'@ define material: Silicon (loss free)

With Material
     .Reset
     .Name "Silicon (loss free)"
.FrqType "all" 
.Type "Normal" 
.Epsilon "11.9" 
.Mue "1.0" 
.Kappa "0.0" 
.TanD "0.0" 
.TanDFreq "0.0" 
.TanDGiven "False" 
.TanDModel "ConstTanD" 
.KappaM "0.0" 
.TanDM "0.0" 
.TanDMFreq "0.0" 
.TanDMGiven "False" 
.TanDMModel "ConstKappa" 
.DispModelEps "None" 
.DispModelMue "None" 
.DispersiveFittingSchemeEps "General 1st" 
.DispersiveFittingSchemeMue "General 1st" 
.UseGeneralDispersionEps "False" 
.UseGeneralDispersionMue "False" 
.Rho "0.0" 
.ThermalType "Normal" 
.ThermalConductivity "148" 
.SetActiveMaterial "all" 
.Colour "0.75", "0.95", "0.85" 
.Wireframe "False" 
.Transparency "0" 
.Create
End With

'@ new component: component1

Component.New "component1"

'@ define brick: component1:silicon base

With Brick
     .Reset 
     .Name "silicon base" 
     .Component "component1" 
     .Material "Silicon (loss free)" 
     .Xrange "-B1/2", "B1/2" 
     .Yrange "-A1/2", "A1/2" 
     .Zrange "0", "siliconthick" 
     .Create
End With

'@ define brick: component1:1top

With Brick
     .Reset 
     .Name "1top" 
     .Component "component1" 
     .Material "Silicon (loss free)" 
     .Xrange "-B", "B" 
     .Yrange "A", "A-cop" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:1right

With Brick
     .Reset 
     .Name "1right" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B", "B-cop" 
     .Yrange "A-cop", "-A" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With

'@ change material: component1:1top to: PEC

Solid.ChangeMaterial "component1:1top", "PEC"

'@ define brick: component1:2bottom

With Brick
     .Reset 
     .Name "2bottom" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-cop", "-B" 
     .Yrange "-A", "-A+cop" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With

'@ define brick: component1:1left

With Brick
     .Reset 
     .Name "1left" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B", "-B+cop" 
     .Yrange "-A+cop", "A-1*cop-1*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:2top

With Brick
     .Reset 
     .Name "2top" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+cop", "B-1*cop-1*spc" 
     .Yrange "A-1*cop-1*spc", "A-2*cop-1*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:solid1

With Brick
     .Reset 
     .Name "solid1" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-1*cop-1*spc", "B-2*cop-1*spc" 
     .Yrange "A-2*cop-1*spc", "-A+1*cop+1*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ rename block: component1:solid1 to: component1:2right

Solid.Rename "component1:solid1", "2right"

'@ define brick: component1:2botom

With Brick
     .Reset 
     .Name "2botom" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-2*cop-1*spc", "-B+1*cop+1*spc" 
     .Yrange "-A+1*cop+1*spc", "-A+2*cop+1*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ rename block: component1:2bottom to: component1:1bottom

Solid.Rename "component1:2bottom", "1bottom"

'@ define brick: component1:2left

With Brick
     .Reset 
     .Name "2left" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+1*cop+1*spc", "-B+2*cop+1*spc" 
     .Yrange "-A+2*cop+1*spc", "A-2*cop-2*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:3top

With Brick
     .Reset 
     .Name "3top" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+2*cop+1*spc", "B-2*cop-2*spc" 
     .Yrange "A-2*cop-2*spc", "A-3*cop-2*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:3right

With Brick
     .Reset 
     .Name "3right" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-2*cop-2*spc", "B-3*cop-2*spc" 
     .Yrange "A-3*cop-2*spc", "-A+2*cop+2*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:3botom

With Brick
     .Reset 
     .Name "3botom" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-3*cop-2*spc", "-B+2*cop+2*spc" 
     .Yrange "-A+2*cop+2*spc", "-A+3*cop+2*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:solid1

With Brick
     .Reset 
     .Name "solid1" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+2*cop+2*spc", "-B+3*cop+2*spc" 
     .Yrange "-A+3*cop+2*spc", "A-3*cop-3*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:4top

With Brick
     .Reset 
     .Name "4top" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+3*cop+2*spc", "B-3*cop-3*spc" 
     .Yrange "A-3*cop-3*spc", "A-4*cop-3*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:solid2

With Brick
     .Reset 
     .Name "solid2" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-3*cop-3*spc", "B-4*cop-3*spc" 
     .Yrange "A-4*cop-3*spc", "-A+3*cop+3*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ rename block: component1:solid1 to: component1:3left

Solid.Rename "component1:solid1", "3left"

'@ rename block: component1:solid2 to: component1:4right

Solid.Rename "component1:solid2", "4right"

'@ define brick: component1:4bottom

With Brick
     .Reset 
     .Name "4bottom" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-4*cop-3*spc", "-B+3*cop+3*spc" 
     .Yrange "-A+3*cop+3*spc", "-A+4*cop+3*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:4left

With Brick
     .Reset 
     .Name "4left" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+3*cop+3*spc", "-B+4*cop+3*spc" 
     .Yrange "-A+4*cop+3*spc", "A-4*cop-4*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:5top

With Brick
     .Reset 
     .Name "5top" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+4*cop+3*spc", "B-4*cop-4*spc" 
     .Yrange "A-4*cop-4*spc", "A-5*cop-4*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:5right

With Brick
     .Reset 
     .Name "5right" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-4*cop-4*spc", "B-5*cop-4*spc" 
     .Yrange "A-5*cop-4*spc", "-A+4*cop+4*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:5bottom

With Brick
     .Reset 
     .Name "5bottom" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-5*cop-4*spc", "-B+4*cop+4*spc" 
     .Yrange "-A+4*cop+4*spc", "-A+5*cop+4*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:5left

With Brick
     .Reset 
     .Name "5left" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+4*cop+4*spc", "-B+5*cop+4*spc" 
     .Yrange "-A+5*cop+4*spc", "A-5*cop-5*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:6top

With Brick
     .Reset 
     .Name "6top" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+5*cop+4*spc", "B-5*cop-5*spc" 
     .Yrange "A-5*cop-5*spc", "A-6*cop-5*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:6right

With Brick
     .Reset 
     .Name "6right" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-5*cop-5*spc", "B-6*cop-5*spc" 
     .Yrange "A-6*cop-5*spc", "-A+5*cop+5*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:6bottom

With Brick
     .Reset 
     .Name "6bottom" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-6*cop-5*spc", "-B+5*cop+5*spc" 
     .Yrange "-A+5*cop+5*spc", "-A+6*cop+5*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:6left

With Brick
     .Reset 
     .Name "6left" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+5*cop+5*spc", "-B+6*cop+5*spc" 
     .Yrange "-A+6*cop+5*spc", "A-6*cop-6*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:7top

With Brick
     .Reset 
     .Name "7top" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+6*cop+5*spc", "B-6*cop-6*spc" 
     .Yrange "A-6*cop-6*spc", "A-7*cop-6*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:7right

With Brick
     .Reset 
     .Name "7right" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-6*cop-6*spc", "B-7*cop-6*spc" 
     .Yrange "A-6*cop-6*spc", "-A+6*cop+6*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:7bottom

With Brick
     .Reset 
     .Name "7bottom" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "B-7*cop-6*spc", "-B+6*cop+6*spc" 
     .Yrange "-A+6*cop+6*spc", "-A+7*cop+6*spc" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define brick: component1:7left

With Brick
     .Reset 
     .Name "7left" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+6*cop+6*spc", "-B+7*cop+6*spc" 
     .Yrange "-A+7*cop+6*spc", "0" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ pick center point

Pick.PickCenterpointFromId "component1:1top", "4"

'@ pick center point

Pick.PickCenterpointFromId "component1:7left", "5"

'@ define discrete port: 1

With DiscretePort 
     .Reset 
     .PortNumber "1" 
     .Type "SParameter" 
     .Impedance "50.0" 
     .Voltage "1.0" 
     .Current "1.0" 
     .Point1 "-16.5", "16.25", "0.235" 
     .Point2 "-10.25", "0", "0.235" 
     .UsePickedPoints "True" 
     .LocalCoordinates "False" 
     .Monitor "False" 
     .Create 
End With

'@ define frequency range

Solver.FrequencyRange "0", "300"

'@ define monitor: e-field (f=150)

With Monitor 
     .Reset 
     .Name "e-field (f=150)" 
     .Dimension "Volume" 
     .Domain "Frequency" 
     .FieldType "Efield" 
     .Frequency "150" 
     .Create 
End With

'@ define farfield monitor: farfield (f=150)

With Monitor 
     .Reset 
     .Name "farfield (f=150)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "150" 
     .Create 
End With

'@ define solver parameters

With Solver 
     .CalculationType "TD-S" 
     .StimulationPort "All" 
     .StimulationMode "All" 
     .SteadyStateLimit "-30" 
     .MeshAdaption "False" 
     .AutoNormImpedance "False" 
     .NormingImpedance "50" 
     .CalculateModesOnly "False" 
     .SParaSymmetry "False" 
     .StoreTDResultsInCache "False" 
     .FullDeembedding "False" 
     .UseDistributedComputing "False" 
End With

'@ delete port: port1

Port.Delete "1"

'@ define cylinder: component1:solid1

With Cylinder 
     .Reset 
     .Name "solid1" 
     .Component "component1" 
     .Material "Silicon (loss free)" 
     .OuterRadius "cop/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "-copperthick", "siliconthick+copperthick" 
     .Xcenter "-B+cop/2" 
     .Ycenter "A-cop/2" 
     .Segments "0" 
     .Create 
End With

'@ boolean insert shapes: component1:silicon base, component1:solid1

Solid.Insert "component1:silicon base", "component1:solid1"

'@ rename block: component1:solid1 to: component1:cylinder

Solid.Rename "component1:solid1", "cylinder"

'@ new curve: curve1

Curve.NewCurve "curve1"

'@ define curve line: curve1:line1

With Line
     .Reset 
     .Name "line1" 
     .Curve "curve1" 
     .X1 "-B" 
     .Y1 "A" 
     .X2 "-3" 
     .Y2 "3" 
     .Create
End With

'@ pick end point

Pick.PickCurveEndpointFromId "curve1:line1", "2"

'@ pick end point

Pick.PickCurveEndpointFromId "curve1:line1", "1"

'@ delete curve: curve1

Curve.DeleteCurve "curve1"

'@ clear picks

Pick.ClearAllPicks

'@ define material colour: Silicon (loss free)

With Material 
     .Name "Silicon (loss free)" 
     .Colour "0.75", "0.95", "0.85" 
     .Wireframe "False" 
     .Transparency "100" 
     .ChangeColour 
End With

'@ pick center point

Pick.PickCenterpointFromId "component1:cylinder", "1"

'@ snap point to drawplane

Pick.SnapLastPointToDrawplane

'@ new curve: curve1

Curve.NewCurve "curve1"

'@ define curve line: curve1:line1

With Line
     .Reset 
     .Name "line1" 
     .Curve "curve1" 
     .X1 "-B+cop/2" 
     .Y1 "A-cop/2" 
     .X2 "-B+cop/2" 
     .Y2 "A-cop/2-1" 
     .Create
End With

'@ store picked point: 1

Pick.NextPickToDatabase "1" 
Pick.PickCurveEndpointFromId "curve1:line1", "2"

'@ define curve line: curve1:line2

With Line
     .Reset 
     .Name "line2" 
     .Curve "curve1" 
     .X1 "-B+cop/2" 
     .Y1 "A-cop/2-1" 
     .X2 "-5" 
     .Y2 "5" 
     .Create
End With

'@ define material colour: Silicon (loss free)

With Material 
     .Name "Silicon (loss free)" 
     .Colour "0.75", "0.95", "0.85" 
     .Wireframe "False" 
     .Transparency "16" 
     .ChangeColour 
End With

'@ define tracefromcurve: component1:solid1

With TraceFromCurve 
     .Reset 
     .Name "solid1" 
     .Component "component1" 
     .Material "Silicon (loss free)" 
     .Curve "curve1:line2" 
     .Thickness "copperthick" 
     .Width "0.5" 
     .RoundStart "True" 
     .RoundEnd "False" 
     .GapType "2" 
     .Create 
End With 


'@ clear picks

Pick.ClearAllPicks

'@ change material: component1:solid1 to: PEC

Solid.ChangeMaterial "component1:solid1", "PEC"

'@ define brick: component1:base2

With Brick
     .Reset 
     .Name "base2" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-5,4", "-3" 
     .Yrange "5,4", "-5,4" 
     .Zrange "-copperthick", "0" 
     .Create
End With

'@ clear picks

Pick.ClearAllPicks

'@ define brick: component1:solid2

With Brick
     .Reset 
     .Name "solid2" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-B+6*cop+6*spc", "-B+6*cop+6*spc+3" 
     .Yrange "-cop/2", "cop/2" 
     .Zrange "siliconthick", "siliconthick+copperthick" 
     .Create
End With


'@ define cylinder: component1:cylinder2

With Cylinder 
     .Reset 
     .Name "cylinder2" 
     .Component "component1" 
     .Material "PEC" 
     .OuterRadius "cop/2" 
     .InnerRadius "0" 
     .Axis "z" 
     .Zrange "-copperthick", "siliconthick+copperthick" 
     .Xcenter "-3.5" 
     .Ycenter "0" 
     .Segments "0" 
     .Create 
End With

'@ store picked point: 2

Pick.NextPickToDatabase "2" 
Pick.PickCirclecenterFromId "component1:cylinder2", "1"

'@ pick circle center point

Pick.PickCirclecenterFromId "component1:cylinder2", "2"

'@ define curve line: curve1:line1

With Line
     .Reset 
     .Name "line1" 
     .Curve "curve1" 
     .X1 "-3.5" 
     .Y1 "0" 
     .X2 "-4" 
     .Y2 "0.0" 
     .Create
End With

'@ define tracefromcurve: component1:solid3

With TraceFromCurve 
     .Reset 
     .Name "solid3" 
     .Component "component1" 
     .Material "PEC" 
     .Curve "curve1:line1" 
     .Thickness "copperthick" 
     .Width "cop" 
     .RoundStart "True" 
     .RoundEnd "False" 
     .GapType "2" 
     .Create 
End With

'@ transform: translate component1:solid3

With Transform 
     .Reset 
     .Name "component1:solid3" 
     .Vector "0", "0", "siliconthick" 
     .UsePickedPoints "False" 
     .InvertPickedPoints "False" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .TranslateAdvanced 
End With

'@ pick center point

Pick.PickCenterpointFromId "component1:solid2", "6"

'@ pick center point

Pick.PickCenterpointFromId "component1:solid3", "2"

'@ define discrete port: 1

With DiscretePort 
     .Reset 
     .PortNumber "1" 
     .Type "SParameter" 
     .Impedance "50.0" 
     .Voltage "1.0" 
     .Current "1.0" 
     .Point1 "-5", "0", "0.235" 
     .Point2 "-4", "0", "0.235" 
     .UsePickedPoints "True" 
     .LocalCoordinates "False" 
     .Monitor "False" 
     .Create 
End With

'@ define solver parameters

With Solver 
     .CalculationType "TD-S" 
     .StimulationPort "All" 
     .StimulationMode "All" 
     .SteadyStateLimit "-30" 
     .MeshAdaption "False" 
     .AutoNormImpedance "False" 
     .NormingImpedance "50" 
     .CalculateModesOnly "False" 
     .SParaSymmetry "False" 
     .StoreTDResultsInCache "False" 
     .FullDeembedding "False" 
     .UseDistributedComputing "False" 
End With

'@ delete port: port1

Port.Delete "1"

'@ define brick: component1:solid4

With Brick
     .Reset 
     .Name "solid4" 
     .Component "component1" 
     .Material "PEC" 
     .Xrange "-6", "-4" 
     .Yrange "-2", "2" 
     .Zrange "10", "-10" 
     .Create
End With

'@ boolean subtract shapes: component1:base2, component1:solid4

Solid.Subtract "component1:base2", "component1:solid4"

'@ pick center point

Pick.PickCenterpointFromId "component1:solid2", "6"

'@ pick center point

Pick.PickCenterpointFromId "component1:solid3", "2"

'@ define discrete port: 1

With DiscretePort 
     .Reset 
     .PortNumber "1" 
     .Type "SParameter" 
     .Impedance "50.0" 
     .Voltage "1.0" 
     .Current "1.0" 
     .Point1 "-5", "0", "0.235" 
     .Point2 "-4", "0", "0.235" 
     .UsePickedPoints "True" 
     .LocalCoordinates "False" 
     .Monitor "False" 
     .Create 
End With

'@ define units

With Units 
     .Geometry "mm" 
     .Frequency "MHz" 
     .Time "s" 
     .Temperature "Celsius" 
     .Voltage "V" 
     .Current "A" 
     .Resistance "Ohm" 
     .Conductance "S" 
     .Capacitance "pF" 
     .Inductance "nH" 
End With

'@ define frequency domain solver parameters

With FDSolver
     .Reset 
     .Method "Tetrahedral Mesh" 
     .OrderTet "Second" 
     .OrderSrf "Second" 
     .UseDistributedComputing "False" 
     .NetworkComputingStrategy "RunRemote" 
     .Stimulation "All", "1" 
     .ResetExcitationList 
     .AutoNormImpedance "False" 
     .NormingImpedance "50" 
     .ModesOnly "False" 
     .AccuracyHex "1e-6" 
     .AccuracyTet "1e-4" 
     .AccuracySrf "1e-3" 
     .LimitIterations "False" 
     .MaxIterations "0" 
     .LimitCPUs "False" 
     .MaxCPUs "2" 
     .StoreAllResults "False" 
     .StoreResultsInCache "False" 
     .UseHelmholtzEquation "True" 
     .LowFrequencyStabilization "True" 
     .Type "Auto" 
     .MeshAdaptionHex "False" 
     .MeshAdaptionTet "True" 
     .AcceleratedRestart "True" 
     .HexMORSettings "", "1001" 
     .NewIterativeSolver "True" 
     .TDCompatibleMaterials "False" 
     .ExtrudeOpenBC "False" 
     .AddMonitorSamples "True" 
     .SParameterSweep "True" 
     .CalcStatBField "False" 
     .UseDoublePrecision "False" 
     .MixedOrder "False" 
     .UsePreconditionerIntEq "False" 
     .PreconditionerAccuracyIntEq "0.15" 
     .MLFMMAccuracy "2.5e-3" 
     .MinMLFMMBoxSize "0.20" 
     .SweepErrorThreshold "True", "0.01" 
     .SweepErrorChecks "2" 
     .SweepMinimumSamples "3" 
     .SweepConsiderAll "True" 
     .SweepConsiderReset 
     .InterpolationSamples "1001" 
     .SweepWeightEvanescent "1.0" 
     .AddSampleInterval "", "", "1", "Automatic", "True" 
     .AddSampleInterval "", "", "", "Automatic", "False" 
End With

'@ set tetrahedral mesh type

Mesh.MeshType "Tetrahedral"

'@ transform: translate component1:solid1

With Transform 
     .Reset 
     .Name "component1:solid1" 
     .Vector "0", "0", "-copperthick" 
     .UsePickedPoints "False" 
     .InvertPickedPoints "False" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .TranslateAdvanced 
End With

'@ define solver parameters

With Solver 
     .CalculationType "TD-S" 
     .StimulationPort "All" 
     .StimulationMode "All" 
     .SteadyStateLimit "-30" 
     .MeshAdaption "False" 
     .AutoNormImpedance "False" 
     .NormingImpedance "50" 
     .CalculateModesOnly "False" 
     .SParaSymmetry "False" 
     .StoreTDResultsInCache "False" 
     .FullDeembedding "False" 
     .UseDistributedComputing "False" 
End With

'@ set pba mesh type

Mesh.MeshType "PBA"

'@ define frequency range

Solver.FrequencyRange "0", "1000"

'@ define background

With Background 
     .Reset 
     .Type "Normal" 
     .Epsilon "1.0" 
     .Mue "1.0" 
     .ThermalType "Normal" 
     .ThermalConductivity "0.0" 
     .XminSpace "10" 
     .XmaxSpace "10" 
     .YminSpace "10" 
     .YmaxSpace "10" 
     .ZminSpace "10" 
     .ZmaxSpace "10" 
     .ApplyInAllDirections "True" 
End With

'@ define boundaries

With Boundary
     .Xmin "open" 
     .Xmax "open" 
     .Ymin "open" 
     .Ymax "open" 
     .Zmin "open" 
     .Zmax "open" 
     .Xsymmetry "none" 
     .Ysymmetry "none" 
     .Zsymmetry "none" 
     .XminThermal "isothermal" 
     .XmaxThermal "isothermal" 
     .YminThermal "isothermal" 
     .YmaxThermal "isothermal" 
     .ZminThermal "isothermal" 
     .ZmaxThermal "isothermal" 
     .XsymmetryThermal "none" 
     .YsymmetryThermal "none" 
     .ZsymmetryThermal "none" 
     .ApplyInAllDirections "True" 
     .XminTemperature "" 
     .XminTemperatureType "None" 
     .XmaxTemperature "" 
     .XmaxTemperatureType "None" 
     .YminTemperature "" 
     .YminTemperatureType "None" 
     .YmaxTemperature "" 
     .YmaxTemperatureType "None" 
     .ZminTemperature "" 
     .ZminTemperatureType "None" 
     .ZmaxTemperature "" 
     .ZmaxTemperatureType "None" 
End With

'@ define probe: probe1

With Probe
     .Reset 
     .Name "probe1" 
     .Field "Efield" 
     .Orientation "X" 
     .Xpos "0.0" 
     .Ypos "0.0" 
     .Zpos "0.0" 
     .Create
End With

'@ delete probe: probe1

Probe.Delete "probe1"

'@ define background

With Background 
     .Reset 
     .Type "Normal" 
     .Epsilon "1.0" 
     .Mue "1.0" 
     .ThermalType "Normal" 
     .ThermalConductivity "0.0" 
     .XminSpace "50" 
     .XmaxSpace "50" 
     .YminSpace "50" 
     .YmaxSpace "50" 
     .ZminSpace "50" 
     .ZmaxSpace "50" 
     .ApplyInAllDirections "True" 
End With

'@ define solver parameters

With Solver 
     .CalculationType "TD-S" 
     .StimulationPort "All" 
     .StimulationMode "All" 
     .SteadyStateLimit "-30" 
     .MeshAdaption "False" 
     .AutoNormImpedance "False" 
     .NormingImpedance "50" 
     .CalculateModesOnly "False" 
     .SParaSymmetry "False" 
     .StoreTDResultsInCache "False" 
     .FullDeembedding "False" 
     .UseDistributedComputing "False" 
End With

'@ define special solver parameters

With Solver 
     .TimeBetweenUpdates "1200" 
     .NumberOfPulseWidths "50" 
     .EnergyBalanceLimit "0.03" 
     .UseArfilter "False" 
     .ArMaxEnergyDeviation "0.1" 
     .ArPulseSkip "1" 
     .WaveguideBroadband "False" 
     .SetBBPSamples "5" 
     .SetSamplesFullDeembedding "20" 
     .MatrixDump "False" 
     .TimestepReduction "0.45" 
     .NumberOfSubcycles "4" 
     .SubcycleFillLimit "70" 
     .UseParallelization "True" 
     .MaximumNumberOfProcessors "2" 
     .TimeStepStabilityFactor "1.0" 
     .UseOpenBoundaryForHigherModes "True" 
     .SetModeFreqFactor "0.1" 
     .SurfaceImpedanceOrder "10" 
     .SetPortShielding "False" 
     .SetTimeStepMethod "Automatic" 
     .FrequencySamples "1001" 
     .ConsiderTwoPortReciprocity "True" 
     .UseTSTAtPort "True" 
     .SubGridTimeCycling "True" 
     .SParaAdjustment "True" 
     .RestartAfterInstabilityAbort "True" 
     .HardwareAcceleration "False" 
End With

'@ define frequency range

Solver.FrequencyRange "0", "30"

'@ define monitor: e-field (f=13)

With Monitor 
     .Delete "e-field (f=150)" 
End With 
With Monitor 
     .Reset 
     .Name "e-field (f=13)" 
     .Dimension "Volume" 
     .Domain "Frequency" 
     .FieldType "Efield" 
     .Frequency "13.56" 
     .Create 
End With

'@ define farfield monitor: farfield (f=13.56)

With Monitor 
     .Delete "farfield (f=150)" 
End With 
With Monitor 
     .Reset 
     .Name "farfield (f=13.56)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "13.56" 
     .Create 
End With

'@ define units

With Units 
     .Geometry "mm" 
     .Frequency "MHz" 
     .Time "ns" 
     .Temperature "Celsius" 
     .Voltage "V" 
     .Current "A" 
     .Resistance "Ohm" 
     .Conductance "S" 
     .Capacitance "pF" 
     .Inductance "nH" 
End With

'@ define background

With Background 
     .Reset 
     .Type "Normal" 
     .Epsilon "1.0" 
     .Mue "1.0" 
     .ThermalType "Normal" 
     .ThermalConductivity "0.0" 
     .XminSpace "40" 
     .XmaxSpace "40" 
     .YminSpace "40" 
     .YmaxSpace "40" 
     .ZminSpace "40" 
     .ZmaxSpace "40" 
     .ApplyInAllDirections "True" 
End With

'@ define frequency range

Solver.FrequencyRange "0", "50"

'@ define boundaries

With Boundary
     .Xmin "open" 
     .Xmax "open" 
     .Ymin "open" 
     .Ymax "open" 
     .Zmin "open" 
     .Zmax "open" 
     .Xsymmetry "none" 
     .Ysymmetry "none" 
     .Zsymmetry "none" 
     .XminThermal "isothermal" 
     .XmaxThermal "isothermal" 
     .YminThermal "isothermal" 
     .YmaxThermal "isothermal" 
     .ZminThermal "isothermal" 
     .ZmaxThermal "isothermal" 
     .XsymmetryThermal "none" 
     .YsymmetryThermal "none" 
     .ZsymmetryThermal "none" 
     .ApplyInAllDirections "True" 
     .XminTemperature "" 
     .XminTemperatureType "None" 
     .XmaxTemperature "" 
     .XmaxTemperatureType "None" 
     .YminTemperature "" 
     .YminTemperatureType "None" 
     .YmaxTemperature "" 
     .YmaxTemperatureType "None" 
     .ZminTemperature "" 
     .ZminTemperatureType "None" 
     .ZmaxTemperature "" 
     .ZmaxTemperatureType "None" 
End With

'@ set mesh properties

With Mesh 
     .UseRatioLimit "True" 
     .RatioLimit "100" 
     .LinesPerWavelength "15" 
     .MinimumStepNumber "10" 
     .Automesh "True" 
     .MeshType "PBA" 
End With 


'@ delete monitor: e-field (f=13)

Monitor.Delete "e-field (f=13)" 


'@ delete monitor: farfield (f=13.56)

Monitor.Delete "farfield (f=13.56)" 


'@ define solver parameters

With Solver 
     .CalculationType "TD-S" 
     .StimulationPort "All" 
     .StimulationMode "All" 
     .SteadyStateLimit "-30" 
     .MeshAdaption "False" 
     .AutoNormImpedance "False" 
     .NormingImpedance "50" 
     .CalculateModesOnly "False" 
     .SParaSymmetry "False" 
     .StoreTDResultsInCache "False" 
     .FullDeembedding "False" 
     .UseDistributedComputing "False" 
End With 


'@ define frequency range

Solver.FrequencyRange "0", "500" 


'@ define monitor: e-field (f=13)

With Monitor 
     .Reset 
     .Name "e-field (f=13)" 
     .Dimension "Volume" 
     .Domain "Frequency" 
     .FieldType "Efield" 
     .Frequency "13.56" 
     .Create 
End With 


'@ define farfield monitor: far-field (f=13)

With Monitor 
     .Reset 
     .Name "far-field (f=13)" 
     .Domain "Frequency" 
     .FieldType "Farfield" 
     .Frequency "13.56" 
     .Create 
End With 


'@ set optimizer specials

With Optimizer 
  .SetOptimizerType "Interpolated_NR_VariableMetric" 
  .SetSimulationType "Transient" 
  .SetAccuracy "0.01" 
  .SetNumRefinements "1" 
  .SetGoalNorm "False" 
  .UseDistributedComputing "False" 
End With 


'@ set optimizer parameters

With Optimizer
  .SetMinMaxAuto "10" 
  .SetAlwaysStartFromCurrent "True" 
  .SelectParameter "spc", "True" 
  .SetParameterInit "1" 
  .SetParameterMin "0.2" 
  .SetParameterMax "1.1" 
  .SetParameterAnchors "5" 
  .SelectParameter "A1", "False" 
  .SetParameterInit "43" 
  .SetParameterMin "38.7" 
  .SetParameterMax "47.3" 
  .SetParameterAnchors "5" 
  .SelectParameter "B1", "False" 
  .SetParameterInit "43" 
  .SetParameterMin "38.7" 
  .SetParameterMax "47.3" 
  .SetParameterAnchors "5" 
  .SelectParameter "cop", "True" 
  .SetParameterInit "0.3" 
  .SetParameterMin "0.2" 
  .SetParameterMax "1.1" 
  .SetParameterAnchors "5" 
  .SelectParameter "copperthick", "False" 
  .SetParameterInit "110e-3" 
  .SetParameterMin "0.099" 
  .SetParameterMax "0.121" 
  .SetParameterAnchors "5" 
  .SelectParameter "siliconthick", "False" 
  .SetParameterInit "180e-3" 
  .SetParameterMin "0.162" 
  .SetParameterMax "0.198" 
  .SetParameterAnchors "5" 
End With 


'@ add optimizer goals: S Parameter / 0

With Optimizer 
  .AddGoal "S Parameter" 
  .SetGoalOperator "<" 
  .SetGoalTarget "-1" 
  .SetGoalWeight "1.0" 
  .SetGoalSScalarType "dB" 
  .SetGoalSPortModes "1", "1", "1", "1" 
  .SetGoalSRange "13.56", "13.56" 
  .SetGoalSRangeType "single" 
  .SetGoalSTargetFrequency "250" 
End With 


'@ set optimizer goals S Parameter / 0

With Optimizer
  .SelectGoal "0", "True" 
  .SetGoalOperator "<" 
  .SetGoalTarget "-1" 
  .SetGoalWeight "1.0" 
  .SetGoalSScalarType "dB" 
  .SetGoalSPortModes "1", "1", "1", "1" 
  .SetGoalSRange "13.56", "13.56" 
  .SetGoalSRangeType "single" 
  .SetGoalSTargetFrequency "250" 
End With 


'@ set optimizer specials

With Optimizer 
  .SetOptimizerType "Interpolated_NR_VariableMetric" 
  .SetSimulationType "Transient" 
  .SetAccuracy "0.01" 
  .SetNumRefinements "1" 
  .SetGoalNorm "False" 
  .UseDistributedComputing "False" 
End With 


