// TestEngineAPI.cs : Declares the DLL functions for C#.
// Generated by ..\..\..\..\..\common\ProdTest\Tools\extract_tt_api.pl from TestEngine.h;  at 29/06/09 - 15:33:32

using System;
using System.Runtime.InteropServices;
using System.Text;

namespace TestEngineAPI
{
    public class TestEngine
    {
#if PocketPC || WindowsCE
        const CharSet charset = CharSet.Auto;
        const CallingConvention calling_convention = CallingConvention.Winapi;
#else
        const CharSet charset = CharSet.Ansi;
        const CallingConvention calling_convention = CallingConvention.StdCall;
#endif

        [DllImport("TestEngine.dll", EntryPoint="teGetVersion",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int teGetVersion(StringBuilder versionStr);
        [DllImport("TestEngine.dll", EntryPoint="teGetVersion",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int teGetVersion(byte [] versionStr);

        [DllImport("TestEngine.dll", EntryPoint="openTestEngine",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern uint openTestEngine(int transport, String transportDevice, uint dataRate, int retryTimeOut, int usbTimeOut);
        [DllImport("TestEngine.dll", EntryPoint="openTestEngine",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern uint openTestEngine(int transport, byte [] transportDevice, uint dataRate, int retryTimeOut, int usbTimeOut);

        [DllImport("TestEngine.dll", EntryPoint="openTestEngineSpi",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern uint openTestEngineSpi(int port, int multi, int transport);

        [DllImport("TestEngine.dll", EntryPoint="openTestEngineSpiTrans",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern uint openTestEngineSpiTrans(String trans, int multi);
        [DllImport("TestEngine.dll", EntryPoint="openTestEngineSpiTrans",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern uint openTestEngineSpiTrans(byte [] trans, int multi);

        [DllImport("TestEngine.dll", EntryPoint="closeTestEngine",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int closeTestEngine(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="teGetLastError",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern uint teGetLastError(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetColdReset",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetColdReset(uint handle, int usbTimeout);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetWarmReset",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetWarmReset(uint handle, int usbTimeout);

        [DllImport("TestEngine.dll", EntryPoint="radiotestPause",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestPause(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="radiotestDeepSleep",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestDeepSleep(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="radiotestPcmExtLb",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestPcmExtLb(uint handle, ushort pcm_mode);

        [DllImport("TestEngine.dll", EntryPoint="radiotestPcmLb",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestPcmLb(uint handle, ushort pcm_mode);

        [DllImport("TestEngine.dll", EntryPoint="radiotestPcmTimingIn",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestPcmTimingIn(uint handle, ushort pio_out, ushort pcm_in);

        [DllImport("TestEngine.dll", EntryPoint="radiotestPcmTone",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestPcmTone(uint handle, ushort freq, ushort ampl, ushort dc);

        [DllImport("TestEngine.dll", EntryPoint="radiotestPcmToneStereo",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestPcmToneStereo(uint handle, ushort freq, ushort ampl, ushort dc, ushort channel);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCtsRtsLb",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCtsRtsLb(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="radiotestRadioStatus",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestRadioStatus(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="hqGetRadioStatus",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hqGetRadioStatus(uint handle, out ushort r, int timeout);

        [DllImport("TestEngine.dll", EntryPoint="radiotestRadioStatusArray",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestRadioStatusArray(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="hqGetRadioStatusArray",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hqGetRadioStatusArray(uint handle, out ushort r, int timeout);

        [DllImport("TestEngine.dll", EntryPoint="bccmdMemoryGet",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdMemoryGet(uint handle, ushort baseAddr, ushort dataLength, out ushort data);

        [DllImport("TestEngine.dll", EntryPoint="bccmdMemorySet",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdMemorySet(uint handle, ushort baseAddr, ushort dataLength, ref ushort data);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetBuildId",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetBuildId(uint handle, out ushort buildid);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBuildName",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBuildName(uint handle, StringBuilder name, ushort max_len, out ushort length);
        [DllImport("TestEngine.dll", EntryPoint="bccmdBuildName",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBuildName(uint handle, byte [] name, ushort max_len, out ushort length);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetChipVersion",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetChipVersion(uint handle, out ushort chipver);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetChipRevision",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetChipRevision(uint handle, out ushort chiprev);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetChipAnaVer",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetChipAnaVer(uint handle, out byte major, out byte minor, out byte vari);

        [DllImport("TestEngine.dll", EntryPoint="bccmdRouteClock",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdRouteClock(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="bccmdRssiAcl",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdRssiAcl(uint handle, ushort connectionHandle, out short rssi);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetPio",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetPio(uint handle, ushort mask, ushort port);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetPio",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetPio(uint handle, out ushort mask, out ushort port);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetAio",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetAio(uint handle, ushort aio, out ushort result, out byte numBits);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBC5MMGetBatteryVoltage",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBC5MMGetBatteryVoltage(uint handle, out ushort voltage);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetFirmwareCheckMask",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetFirmwareCheckMask(uint handle, out ushort mask);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetFirmwareCheck",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetFirmwareCheck(uint handle, out ushort check);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetExternalClockPeriod",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetExternalClockPeriod(uint handle, out ushort period);

        [DllImport("TestEngine.dll", EntryPoint="bccmdEnableDeviceConnect",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdEnableDeviceConnect(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="bccmdEnableDeviceUnderTestMode",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdEnableDeviceUnderTestMode(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="radiotestStereoCodecLB",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestStereoCodecLB(uint handle, ushort sampleRate, ushort reroute);

        [DllImport("TestEngine.dll", EntryPoint="radiotestTxstart",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestTxstart(uint handle, ushort frequency, ushort intPA, ushort extPA, short modulation);

        [DllImport("TestEngine.dll", EntryPoint="radiotestTxdata1",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestTxdata1(uint handle, ushort frequency, ushort intPA, ushort extPA);

        [DllImport("TestEngine.dll", EntryPoint="radiotestTxdata2",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestTxdata2(uint handle, ushort countrycode, ushort intPA, ushort extPA);

        [DllImport("TestEngine.dll", EntryPoint="radiotestTxdata3",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestTxdata3(uint handle, ushort frequency, ushort intPA, ushort extPA);

        [DllImport("TestEngine.dll", EntryPoint="radiotestTxdata4",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestTxdata4(uint handle, ushort frequency, ushort intPA, ushort extPA);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgTxPower",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgTxPower(uint handle, short power);

        [DllImport("TestEngine.dll", EntryPoint="radiotestRxstart1",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestRxstart1(uint handle, ushort frequency, byte hiside, ushort rx_attenuation);

        [DllImport("TestEngine.dll", EntryPoint="radiotestRxstart2",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestRxstart2(uint handle, ushort frequency, byte hiside, ushort rx_attenuation, ushort sample_size);

        [DllImport("TestEngine.dll", EntryPoint="hqGetRssi",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hqGetRssi(uint handle, int timeout, ushort max_size, out ushort r);

        [DllImport("TestEngine.dll", EntryPoint="radiotestBer1",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestBer1(uint handle, ushort frequency, byte hiside, ushort rx_attenuation, uint sampleSize);

        [DllImport("TestEngine.dll", EntryPoint="radiotestBer2",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestBer2(uint handle, ushort country_code, byte hiside, ushort rx_attenuation, uint sampleSize);

        [DllImport("TestEngine.dll", EntryPoint="radiotestBerLoopback",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestBerLoopback(uint handle, ushort frequency, ushort intPA, ushort extPA, uint sampleSize);

        [DllImport("TestEngine.dll", EntryPoint="radiotestRxLoopback",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestRxLoopback(uint handle, ushort frequency, ushort intPA, ushort extPA);

        [DllImport("TestEngine.dll", EntryPoint="radiotestLoopback",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestLoopback(uint handle, ushort frequency, ushort intPA, ushort extPA);

        [DllImport("TestEngine.dll", EntryPoint="hqGetBer",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hqGetBer(uint handle, int timeout, out uint r);

        [DllImport("TestEngine.dll", EntryPoint="radiotestRxdata1",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestRxdata1(uint handle, ushort frequency, byte hiside, ushort rx_attenuation);

        [DllImport("TestEngine.dll", EntryPoint="radiotestRxdata2",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestRxdata2(uint handle, ushort countrycode, byte hiside, ushort rx_attenuation);

        [DllImport("TestEngine.dll", EntryPoint="hqGetRxdata",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hqGetRxdata(uint handle, int timeout, out ushort r);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgFreq",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgFreq(uint handle, ushort txrxinterval, ushort loopback, ushort report);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgFreqMs",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgFreqMs(uint handle, ushort txrxinterval, ushort loopback, ushort report);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgPkt",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgPkt(uint handle, ushort aType, ushort size);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgBitError",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgBitError(uint handle, uint sampleSize, byte reset);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgTxPaAtten",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgTxPaAtten(uint handle, ushort atten);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgXtalFtrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgXtalFtrim(uint handle, ushort ftrim);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgUapLap",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgUapLap(uint handle, ushort uap, uint lap);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgIqTrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgIqTrim(uint handle, ushort trim);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgTxIf",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgTxIf(uint handle, short offset);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgTxTrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgTxTrim(uint handle, ushort am_addr);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgLoLvl",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgLoLvl(uint handle, ushort lo_lvl);

        [DllImport("TestEngine.dll", EntryPoint="radiotestCfgHoppingSeq",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestCfgHoppingSeq(uint handle, out ushort channels);

        [DllImport("TestEngine.dll", EntryPoint="radiotestSettle",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int radiotestSettle(uint handle, ushort start, ushort aEnd);

        [DllImport("TestEngine.dll", EntryPoint="hqGetSettle",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hqGetSettle(uint handle, out ushort r);

        [DllImport("TestEngine.dll", EntryPoint="get_freq_offset",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int get_freq_offset(uint handle, out double offset, int sample_size);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetEeprom",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetEeprom(uint handle, ushort log2bytes, ushort addrMask);

        [DllImport("TestEngine.dll", EntryPoint="psReadBdAddr",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadBdAddr(uint handle, out uint lap, out byte uap, out ushort nap);

        [DllImport("TestEngine.dll", EntryPoint="psRead",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psRead(uint handle, ushort ps_key, ushort store, ushort arraylen, out ushort ps, out ushort aLen);

        [DllImport("TestEngine.dll", EntryPoint="psClear",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psClear(uint handle, ushort ps_key, ushort store);

        [DllImport("TestEngine.dll", EntryPoint="psClearAll",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psClearAll(uint handle, ushort store);

        [DllImport("TestEngine.dll", EntryPoint="psFactorySet",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psFactorySet(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="psFactoryRestoreAll",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psFactoryRestoreAll(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="psFactoryRestore",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psFactoryRestore(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="psSize",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psSize(uint handle, ushort pskey, ushort store, out ushort size);

        [DllImport("TestEngine.dll", EntryPoint="psWrite",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWrite(uint handle, ushort ps_key, ushort store, ushort ps_length, ref ushort ps);

        [DllImport("TestEngine.dll", EntryPoint="psWriteVerify",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteVerify(uint handle, ushort ps_key, ushort store, ushort ps_length, ref ushort ps);

        [DllImport("TestEngine.dll", EntryPoint="psWriteBdAddr",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteBdAddr(uint handle, uint lap, uint uap, uint nap);

        [DllImport("TestEngine.dll", EntryPoint="psReadModuleId",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadModuleId(uint handle, out uint module_id);

        [DllImport("TestEngine.dll", EntryPoint="psReadXtalFtrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadXtalFtrim(uint handle, out ushort ftrim);

        [DllImport("TestEngine.dll", EntryPoint="psWriteXtalFtrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteXtalFtrim(uint handle, ushort ftrim);

        [DllImport("TestEngine.dll", EntryPoint="psWriteModuleSecurityCode",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteModuleSecurityCode(uint handle, ref ushort code);

        [DllImport("TestEngine.dll", EntryPoint="psWriteModuleId",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteModuleId(uint handle, uint module_id);

        [DllImport("TestEngine.dll", EntryPoint="psWriteBaudrate",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteBaudrate(uint handle, ushort value);

        [DllImport("TestEngine.dll", EntryPoint="psWriteRadiotestFirstTrimTime",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteRadiotestFirstTrimTime(uint handle, uint time);

        [DllImport("TestEngine.dll", EntryPoint="psReadRadiotestFirstTrimTime",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadRadiotestFirstTrimTime(uint handle, out uint time);

        [DllImport("TestEngine.dll", EntryPoint="psWriteRadiotestLoLvlTrimEnable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteRadiotestLoLvlTrimEnable(uint handle, ushort state);

        [DllImport("TestEngine.dll", EntryPoint="psReadRadiotestLoLvlTrimEnable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadRadiotestLoLvlTrimEnable(uint handle, out ushort state);

        [DllImport("TestEngine.dll", EntryPoint="psWriteRadiotestSubsequentTrimTime",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteRadiotestSubsequentTrimTime(uint handle, uint time);

        [DllImport("TestEngine.dll", EntryPoint="psReadRadiotestSubsequentTrimTime",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadRadiotestSubsequentTrimTime(uint handle, out uint time);

        [DllImport("TestEngine.dll", EntryPoint="psWriteHostInterface",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteHostInterface(uint handle, ushort transport);

        [DllImport("TestEngine.dll", EntryPoint="psReadHostInterface",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadHostInterface(uint handle, out ushort transport);

        [DllImport("TestEngine.dll", EntryPoint="psWriteUsbAttributes",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteUsbAttributes(uint handle, ushort bmAttributes);

        [DllImport("TestEngine.dll", EntryPoint="psWriteDPlusPullup",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteDPlusPullup(uint handle, ushort pio_pin);

        [DllImport("TestEngine.dll", EntryPoint="psWriteUsbMaxPower",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteUsbMaxPower(uint handle, ushort max_power);

        [DllImport("TestEngine.dll", EntryPoint="psWritePioProtectMask",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWritePioProtectMask(uint handle, ushort mask);

        [DllImport("TestEngine.dll", EntryPoint="psReadPioProtectMask",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadPioProtectMask(uint handle, out ushort mask);

        [DllImport("TestEngine.dll", EntryPoint="psWriteTxOffsetHalfMhz",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteTxOffsetHalfMhz(uint handle, short offset);

        [DllImport("TestEngine.dll", EntryPoint="psReadTxOffsetHalfMhz",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadTxOffsetHalfMhz(uint handle, out short offset);

        [DllImport("TestEngine.dll", EntryPoint="psWriteUsrValue",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteUsrValue(uint handle, ushort user_no, ushort length, ref ushort entry);

        [DllImport("TestEngine.dll", EntryPoint="psReadUsrValue",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadUsrValue(uint handle, ushort user_no, ushort maxLen, out ushort length, out ushort entry);

        [DllImport("TestEngine.dll", EntryPoint="psWritePowerTable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWritePowerTable(uint handle, ushort num_entries, ref byte intPA, ref byte extPA, ref int power);

        [DllImport("TestEngine.dll", EntryPoint="psReadPowerTable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadPowerTable(uint handle, int maxSize, out int num_entries, out byte intPA, out byte extPA, out int power);

        [DllImport("TestEngine.dll", EntryPoint="psWriteVmDisable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psWriteVmDisable(uint handle, byte vmDisable);

        [DllImport("TestEngine.dll", EntryPoint="psReadVmDisable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int psReadVmDisable(uint handle, out byte vmDisable);

        [DllImport("TestEngine.dll", EntryPoint="hciSlave",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSlave(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="hciSetAfhHostChannelClass",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSetAfhHostChannelClass(uint handle, ref byte cClass);

        [DllImport("TestEngine.dll", EntryPoint="hciReadAfhChannelMap",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciReadAfhChannelMap(uint handle, ushort aclHandle, out byte mode, out byte cMap);

        [DllImport("TestEngine.dll", EntryPoint="hciSetEventFilterAutoacceptConnection",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSetEventFilterAutoacceptConnection(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="hciWriteInquiryScanActivity",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWriteInquiryScanActivity(uint handle, ushort inquiryscan_interval, ushort inquiryscan_window);

        [DllImport("TestEngine.dll", EntryPoint="hciWritePageScanActivity",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWritePageScanActivity(uint handle, ushort pagescan_interval, ushort pagescan_window);

        [DllImport("TestEngine.dll", EntryPoint="hciWriteScanEnable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWriteScanEnable(uint handle, byte scan_enable);

        [DllImport("TestEngine.dll", EntryPoint="hciInquiry",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciInquiry(uint handle, byte inquiryLength, byte numResponses, uint lap);

        [DllImport("TestEngine.dll", EntryPoint="hciGetInquiryResults",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetInquiryResults(uint handle, out uint lap, out byte uap, out ushort nap, out ushort clockOffset, uint maxLen, out uint aLen);

        [DllImport("TestEngine.dll", EntryPoint="hciInquiryCancel",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciInquiryCancel(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="hciCreateConnection",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciCreateConnection(uint handle, uint lap, byte uap, ushort nap, ushort pkt_type, out ushort connectionHandle);

        [DllImport("TestEngine.dll", EntryPoint="hciCreateConnectionNoInquiry",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciCreateConnectionNoInquiry(uint handle, uint lap, byte uap, ushort nap, ushort pkt_type, byte page_scan_rep_mode, byte page_scan_mode, ushort clock_offset, byte allow_role_switch, out ushort connectionHandle);

        [DllImport("TestEngine.dll", EntryPoint="hciCreateScoConnection",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciCreateScoConnection(uint handle, ushort aclConnectionHandle, ushort pkt_type, out ushort scoConnectionHandle);

        [DllImport("TestEngine.dll", EntryPoint="hciSetupScoConnection",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSetupScoConnection(uint handle, ushort aclConnectionHandle, uint txBandwidth, uint rxBandwidth, ushort maxLatency, ushort voiceSetting, byte retransEffort, ushort pktType, out ushort scoConnectionHandle);

        [DllImport("TestEngine.dll", EntryPoint="hciReadVoiceSetting",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciReadVoiceSetting(uint handle, out ushort voiceSetting);

        [DllImport("TestEngine.dll", EntryPoint="hciWriteVoiceSetting",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWriteVoiceSetting(uint handle, ushort voiceSetting);

        [DllImport("TestEngine.dll", EntryPoint="hciWriteLinkPolicySettings",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWriteLinkPolicySettings(uint handle, ushort connection_handle, ushort link_policy_settings);

        [DllImport("TestEngine.dll", EntryPoint="hciSendAclFile",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSendAclFile(uint handle, ushort connHandle, String fileName);
        [DllImport("TestEngine.dll", EntryPoint="hciSendAclFile",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSendAclFile(uint handle, ushort connHandle, byte [] fileName);

        [DllImport("TestEngine.dll", EntryPoint="hciSendAclData",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSendAclData(uint handle, ushort connHandle, ref byte data, ushort length);

        [DllImport("TestEngine.dll", EntryPoint="hciGetAclData",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetAclData(uint handle, out byte data, out uint numBytes);

        [DllImport("TestEngine.dll", EntryPoint="hciGetAclBytesRead",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetAclBytesRead(uint handle, out uint numBytes);

        [DllImport("TestEngine.dll", EntryPoint="hciGetAclFileName",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetAclFileName(uint handle, StringBuilder fileName, out uint length);
        [DllImport("TestEngine.dll", EntryPoint="hciGetAclFileName",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetAclFileName(uint handle, byte [] fileName, out uint length);

        [DllImport("TestEngine.dll", EntryPoint="hciGetAclState",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetAclState(uint handle, out int state);

        [DllImport("TestEngine.dll", EntryPoint="hciResetAclState",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciResetAclState(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="hciReset",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciReset(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetAnaXtalFtrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetAnaXtalFtrim(uint handle, out ushort ftrim);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetAnaXtalFtrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetAnaXtalFtrim(uint handle, ushort ftrim);

        [DllImport("TestEngine.dll", EntryPoint="hciSniffMode",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSniffMode(uint handle, ushort connection_handle, ushort sniff_max_interval, ushort sniff_min_interval, ushort sniff_attempt, ushort sniff_timeout);

        [DllImport("TestEngine.dll", EntryPoint="hciExitSniff",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciExitSniff(uint handle, ushort connection_handle);

        [DllImport("TestEngine.dll", EntryPoint="hciDisconnect",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciDisconnect(uint handle, ushort connection_handle);

        [DllImport("TestEngine.dll", EntryPoint="hciGetConnectionHandle",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetConnectionHandle(uint handle, uint lap, byte uap, ushort nap, out ushort connectionHandle);

        [DllImport("TestEngine.dll", EntryPoint="hciConnectionStatus",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciConnectionStatus(uint handle, ushort connection_handle);

        [DllImport("TestEngine.dll", EntryPoint="hciEnableDeviceUnderTestMode",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciEnableDeviceUnderTestMode(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="hciGetLinkQuality",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciGetLinkQuality(uint handle, ushort connection_handle, out byte quality);

        [DllImport("TestEngine.dll", EntryPoint="hciReadRemoteVersionInformation",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciReadRemoteVersionInformation(uint handle, ushort connection_handle, out uint r);

        [DllImport("TestEngine.dll", EntryPoint="hciReadRemoteNameRequest",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciReadRemoteNameRequest(uint handle, uint lap, byte uap, ushort nap, byte page_scan_repetition_mode, byte page_scan_offset, ushort clock_offset, StringBuilder r);
        [DllImport("TestEngine.dll", EntryPoint="hciReadRemoteNameRequest",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciReadRemoteNameRequest(uint handle, uint lap, byte uap, ushort nap, byte page_scan_repetition_mode, byte page_scan_offset, ushort clock_offset, byte [] r);

        [DllImport("TestEngine.dll", EntryPoint="dmRegisterReq",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int dmRegisterReq(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="dmSlave",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int dmSlave(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="dmEnableDeviceUnderTestMode",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int dmEnableDeviceUnderTestMode(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="dmWritePageScanActivity",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int dmWritePageScanActivity(uint handle, ushort pagescan_interval, ushort pagescan_window);

        [DllImport("TestEngine.dll", EntryPoint="dmWriteInquiryScanActivity",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int dmWriteInquiryScanActivity(uint handle, ushort inquiryscan_interval, ushort inquiryscan_window);

        [DllImport("TestEngine.dll", EntryPoint="dmWriteScanEnable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int dmWriteScanEnable(uint handle, byte scan_enable);

        [DllImport("TestEngine.dll", EntryPoint="dmSetEventFilterAutoacceptConnection",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int dmSetEventFilterAutoacceptConnection(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBc3PsuTrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBc3PsuTrim(uint handle, ushort data);

        [DllImport("TestEngine.dll", EntryPoint="bccmdChargerPsuTrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdChargerPsuTrim(uint handle, ushort trim);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBc3BuckReg",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBc3BuckReg(uint handle, ushort data);

        [DllImport("TestEngine.dll", EntryPoint="bccmdPsuBuckReg",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdPsuBuckReg(uint handle, ushort reg);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBc3MicEn",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBc3MicEn(uint handle, ushort data);

        [DllImport("TestEngine.dll", EntryPoint="bccmdPsuMicEn",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdPsuMicEn(uint handle, ushort reg);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBc3Led0",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBc3Led0(uint handle, ushort data);

        [DllImport("TestEngine.dll", EntryPoint="bccmdLed0",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdLed0(uint handle, ushort state);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBc3Led1",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBc3Led1(uint handle, ushort data);

        [DllImport("TestEngine.dll", EntryPoint="bccmdLed1",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdLed1(uint handle, ushort state);

        [DllImport("TestEngine.dll", EntryPoint="bccmdChargerStatus",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdChargerStatus(uint handle, out ushort state);

        [DllImport("TestEngine.dll", EntryPoint="bccmdChargerDisable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdChargerDisable(uint handle, ushort state);

        [DllImport("TestEngine.dll", EntryPoint="bccmdChargerSupressLed0",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdChargerSupressLed0(uint handle, ushort state);

        [DllImport("TestEngine.dll", EntryPoint="hciCreateConnectionNoWait",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciCreateConnectionNoWait(uint handle, uint lap, byte uap, ushort nap, ushort pktType, byte pageScanRepMode, byte pageScanMode, ushort clockOffset, byte allowRoleSwitch);

        [DllImport("TestEngine.dll", EntryPoint="hciWriteAuthenticationEnable",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWriteAuthenticationEnable(uint handle, byte enable);

        [DllImport("TestEngine.dll", EntryPoint="hciLinkKeyRequestNegativeReply",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciLinkKeyRequestNegativeReply(uint handle, uint lap, byte uap, ushort nap);

        [DllImport("TestEngine.dll", EntryPoint="hciWaitForConnectionComplete",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWaitForConnectionComplete(uint handle, out ushort connHandle);

        [DllImport("TestEngine.dll", EntryPoint="hciWaitForLinkKeyRequest",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWaitForLinkKeyRequest(uint handle, out uint lap, out byte uap, out ushort nap);

        [DllImport("TestEngine.dll", EntryPoint="hciWaitForPinCodeRequest",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWaitForPinCodeRequest(uint handle, out uint lap, out byte uap, out ushort nap);

        [DllImport("TestEngine.dll", EntryPoint="hciWaitForEncryptionChange",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciWaitForEncryptionChange(uint handle, out byte enable);

        [DllImport("TestEngine.dll", EntryPoint="hciPinCodeRequestReply",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciPinCodeRequestReply(uint handle, uint lap, byte uap, ushort nap, byte pinCodeLength, out byte pinCode);

        [DllImport("TestEngine.dll", EntryPoint="hciSetConnectionEncryption",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hciSetConnectionEncryption(uint handle, ushort connHandle, byte enable);

        [DllImport("TestEngine.dll", EntryPoint="vmWrite",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int vmWrite(uint handle, ref ushort data);

        [DllImport("TestEngine.dll", EntryPoint="vmRead",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int vmRead(uint handle, out ushort data, ushort timeout);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetSingleChan",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetSingleChan(uint handle, ushort channel);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetHoppingOn",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetHoppingOn(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmSwitchPower",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmSwitchPower(uint handle, byte powerOn);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmSetFreq",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmSetFreq(uint handle, uint freqKHz);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmGetRssi",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmGetRssi(uint handle, out sbyte rssi);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmGetSnr",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmGetSnr(uint handle, out short snr);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmGetIfOffset",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmGetIfOffset(uint handle, out short offset);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmGetStatus",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmGetStatus(uint handle, out byte status);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmSetupAudio",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmSetupAudio(uint handle, byte route, byte gain, byte channel);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmVerifyRDSPi",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmVerifyRDSPi(uint handle, ushort pi, ushort timeoutMs, out byte matched);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmTxSwitchPower",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmTxSwitchPower(uint handle, byte powerOn);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmTxSetFreq",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmTxSetFreq(uint handle, uint freqKHz);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmTxSetPowerLevel",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmTxSetPowerLevel(uint handle, short powerLevel);

        [DllImport("TestEngine.dll", EntryPoint="bccmdFmTxSetupAudio",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdFmTxSetupAudio(uint handle, byte route, ushort audioGain);

        [DllImport("TestEngine.dll", EntryPoint="bccmdDisconnectAudio",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdDisconnectAudio(uint handle);

        [DllImport("TestEngine.dll", EntryPoint="bccmdDirectChargerPsuTrim",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdDirectChargerPsuTrim(uint handle, ushort trim);

        [DllImport("TestEngine.dll", EntryPoint="teSupportsHq",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int teSupportsHq(uint handle, out byte hqSupported);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetAuxDac",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetAuxDac(uint handle, byte enable, byte level);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetMicBias",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetMicBias(uint handle, byte enable, byte voltage, byte current, byte enableLowPowerMode);

        [DllImport("TestEngine.dll", EntryPoint="teGetAvailableSpiPorts",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int teGetAvailableSpiPorts(out ushort maxLen, StringBuilder ports, StringBuilder trans, out ushort count);
        [DllImport("TestEngine.dll", EntryPoint="teGetAvailableSpiPorts",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int teGetAvailableSpiPorts(out ushort maxLen, byte [] ports, byte [] trans, out ushort count);

        [DllImport("TestEngine.dll", EntryPoint="bccmdProvokeFault",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdProvokeFault(uint handle, ushort faultCode);

        [DllImport("TestEngine.dll", EntryPoint="hqGetFaultReports",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int hqGetFaultReports(uint handle, ushort maxReports, out ushort codes, out uint timestamps, out ushort repeats, out ushort numReports, int timeout);

        [DllImport("TestEngine.dll", EntryPoint="teGetFaultDesc",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int teGetFaultDesc(uint handle, ushort faultCode, StringBuilder desc);
        [DllImport("TestEngine.dll", EntryPoint="teGetFaultDesc",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int teGetFaultDesc(uint handle, ushort faultCode, byte [] desc);

        [DllImport("TestEngine.dll", EntryPoint="bccmdSetMapScoPcm",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdSetMapScoPcm(uint handle, byte enable);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetVrefConstant",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetVrefConstant(uint handle, out ushort vref);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetVrefAdc",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetVrefAdc(uint handle, out ushort result, out byte numBits);

        [DllImport("TestEngine.dll", EntryPoint="bccmdBC5FMGetI2CState",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdBC5FMGetI2CState(uint handle, out byte sda, out byte scl);

        [DllImport("TestEngine.dll", EntryPoint="refEpGetRssiDbm",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int refEpGetRssiDbm(uint handle, ushort freqMHz, double rssiChip, out double rssiDbm);

        [DllImport("TestEngine.dll", EntryPoint="refEpGetPaLevel",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int refEpGetPaLevel(uint handle, ushort freqMHz, double targetPowerDbm, out ushort intPa, out double powerDbm);

        [DllImport("TestEngine.dll", EntryPoint="refEpWriteCalDataFile",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int refEpWriteCalDataFile(uint handle, String filePath);
        [DllImport("TestEngine.dll", EntryPoint="refEpWriteCalDataFile",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int refEpWriteCalDataFile(uint handle, byte [] filePath);

        [DllImport("TestEngine.dll", EntryPoint="refEpLoadCalDataFile",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int refEpLoadCalDataFile(uint handle, String filePath);
        [DllImport("TestEngine.dll", EntryPoint="refEpLoadCalDataFile",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int refEpLoadCalDataFile(uint handle, byte [] filePath);

        [DllImport("TestEngine.dll", EntryPoint="bccmdGetVmStatus",
                CharSet=charset, CallingConvention=calling_convention)]
        public static extern int bccmdGetVmStatus(uint handle, out ushort status, out ushort exitCode);

    }
}
